/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.biene.db;

import com.gmail.berndivader.biene.Logger;
import com.gmail.berndivader.biene.Utils;
import com.gmail.berndivader.biene.config.Config;
import com.gmail.berndivader.biene.db.DatabaseConnection;
import com.gmail.berndivader.biene.db.QueryBatchTask;
import com.gmail.berndivader.biene.db.SimpleQuery;
import com.gmail.berndivader.biene.db.UpdatePicturesTask;
import com.gmail.berndivader.biene.enums.Action;
import com.gmail.berndivader.biene.http.post.PostImportCSVSync;
import com.gmail.berndivader.biene.http.post.PostUploadCSV;
import com.gmail.berndivader.biene.http.post.PostValidateImageFileSync;
import com.gmail.berndivader.biene.rtf2html.RtfHtml;
import com.gmail.berndivader.biene.rtf2html.RtfReader;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.concurrent.TimeUnit;

public class UpdateShopTask
extends QueryBatchTask {
    private static final String START_INFO = "-- Starte Shop Update Task %s...";
    private static final String SCHEDULED_INFO = "-- Scheduled Shop Update Task %s...";
    private static final String END_INFO = "-- Beende Shop Update Task %s.";
    private RtfReader rtfReader;
    private RtfHtml rtfHtml;
    private boolean withImageUpdate;

    public UpdateShopTask(boolean withImageUpdate) {
        super(Config.data.winline_query());
        this.withImageUpdate = withImageUpdate;
        this.add();
        Logger.$(String.format(SCHEDULED_INFO, this.uuid.toString()), false, false);
    }

    public UpdateShopTask() {
        this(true);
    }

    @Override
    public Boolean call() throws Exception {
        Logger.$(String.format(START_INFO, this.uuid.toString()), false, true);
        int mesoYear = Config.data.meso_year();
        this.query = this.query.replace("$mesoyear$", Integer.toString((mesoYear - 1900) * 12));
        try (Connection conn = DatabaseConnection.getNewConnection();){
            String s1;
            conn.prepareStatement(this.query).execute();
            Object update_info = "";
            StringBuilder csv_string = new StringBuilder(Config.data.csv_header().concat("\n"));
            int change_counter = 0;
            this.rtfReader = new RtfReader();
            this.rtfHtml = new RtfHtml();
            try (PreparedStatement statement = conn.prepareStatement(Config.data.updates_query(), 1004, 1007);
                 ResultSet changes = statement.executeQuery();){
                if (changes.first()) {
                    do {
                        this.validateImage(changes.getString("c076"));
                        csv_string.append(Utils.makeCSVLine(Action.UPDATE, changes, this.rtfReader, this.rtfHtml));
                    } while (changes.next());
                    changes.last();
                    change_counter += changes.getRow();
                    s1 = changes.getRow() == 1 ? "" : "en";
                    update_info = (String)update_info + Integer.toString(changes.getRow()).concat(" \u00c4nderung").concat(s1).concat(", ");
                } else {
                    update_info = (String)update_info + "0 \u00c4nderungen, ";
                }
            }
            statement = conn.prepareStatement(Config.data.inserts_query(), 1004, 1007);
            try (ResultSet inserts = statement.executeQuery();){
                if (inserts.first()) {
                    do {
                        this.validateImage(inserts.getString("c076"));
                        csv_string.append(Utils.makeCSVLine(Action.INSERT, inserts, this.rtfReader, this.rtfHtml));
                    } while (inserts.next());
                    inserts.last();
                    change_counter += inserts.getRow();
                    s1 = inserts.getRow() == 1 ? "" : "en";
                    update_info = (String)update_info + Integer.toString(inserts.getRow()).concat(" Neuerung").concat(s1).concat(" und ");
                } else {
                    update_info = (String)update_info + "0 Neuerungen und ";
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            statement = conn.prepareStatement(Config.data.deletes_query(), 1004, 1007);
            try (ResultSet deletes = statement.executeQuery();){
                if (deletes.first()) {
                    do {
                        csv_string.append(Utils.makeCSVLine(Action.DELETE, deletes, this.rtfReader, this.rtfHtml));
                    } while (deletes.next());
                    deletes.last();
                    change_counter += deletes.getRow();
                    s1 = deletes.getRow() == 1 ? "" : "en";
                    update_info = (String)update_info + Integer.toString(deletes.getRow()).concat(" L\u00f6schung").concat(s1).concat(" gefunden.");
                } else {
                    update_info = (String)update_info + "0 L\u00f6schungen gefunden.";
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            Logger.$((String)update_info, false, true);
            if (change_counter > 0) {
                File csv_file = Utils.create_csv_file(csv_string.toString());
                if (csv_file != null && csv_file.exists()) {
                    String file_name = csv_file.getName();
                    PostUploadCSV upload = new PostUploadCSV(Config.data.http_string(), csv_file);
                    upload.latch.await(upload.max_seconds, TimeUnit.SECONDS);
                    if (!upload.failed) {
                        PostImportCSVSync csv_import = new PostImportCSVSync(Config.data.http_string(), file_name);
                        if (csv_import.join() && !csv_import.failed) {
                            SimpleQuery query = new SimpleQuery(Config.data.verify_query());
                            query.latch.await(query.max_seconds, TimeUnit.SECONDS);
                        }
                    } else {
                        Logger.$("-- Upload csv file failed", true);
                    }
                } else {
                    Logger.$("-- Failed to create csv file", true);
                }
                csv_file.delete();
            }
            this.completed(null);
        }
        catch (Exception ex) {
            Logger.$(ex, false, true);
            this.failed(null);
        }
        if (this.withImageUpdate) {
            new UpdatePicturesTask();
        }
        this.took();
        this.latch.countDown();
        return true;
    }

    private void validateImage(String image_name) {
        if (image_name != null && image_name.length() > 0) {
            new PostValidateImageFileSync(Config.data.http_string(), image_name);
        }
    }

    @Override
    public void completed(Void result) {
        Logger.$(String.format(END_INFO, this.uuid.toString()), false, true);
    }

    @Override
    public void failed(Void result) {
    }

    @Override
    protected void max_seconds(long max) {
        this.max_seconds = 180L;
    }
}

