/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.biene.gui;

import com.gmail.berndivader.biene.Logger;
import com.gmail.berndivader.biene.Utils;
import com.gmail.berndivader.biene.db.UpdateShopTask;
import com.gmail.berndivader.biene.gui.Settings;
import com.gmail.berndivader.biene.http.post.PostXAuthTokenRequestSync;
import java.awt.AWTException;
import java.awt.Font;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class Main
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static boolean exit;
    private JPanel contentPane;
    public static Main instance;
    public static final String APP_NAME = "WinLine2Modified";
    public static Image icon_image;
    private Settings settings;
    public JTextArea log_area;
    private JScrollPane scrollBar;
    private TrayIcon tray_icon;
    private SystemTray tray;
    private PopupMenu popup;

    public static void create() {
        icon_image = Main.createImage("/appicon.gif", APP_NAME);
        new Main();
    }

    private static Image createImage(String path, String description) {
        URL url = Main.class.getResource(path);
        if (url == null) {
            return new ImageIcon(new BufferedImage(32, 32, 2)).getImage();
        }
        return new ImageIcon(url, description).getImage();
    }

    private Main() {
        instance = this;
        this.setDefaultCloseOperation(2);
        exit = false;
        this.setType(Window.Type.NORMAL);
        this.setFont(new Font("Monospaced", 0, 11));
        this.setTitle(APP_NAME);
        this.setBounds(100, 100, 603, 560);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BoxLayout(this.contentPane, 0));
        this.addWindowStateListener(new WindowStateListener(){

            @Override
            public void windowStateChanged(WindowEvent e) {
                if (e.getNewState() == 1) {
                    instance.setVisible(false);
                }
            }
        });
        if (SystemTray.isSupported()) {
            this.tray_icon = new TrayIcon(icon_image);
            instance.setIconImage(icon_image);
            this.tray = SystemTray.getSystemTray();
            try {
                this.tray.add(this.tray_icon);
            }
            catch (AWTException e) {
                Logger.$(e, false, true);
            }
            this.tray_icon.setPopupMenu(this.createPopup());
        }
        this.log_area = new JTextArea();
        this.log_area.setDropMode(DropMode.INSERT);
        this.log_area.setFont(new Font("Monospaced", 0, 11));
        this.log_area.setEditable(false);
        this.log_area.setLineWrap(true);
        this.popup = this.createPopup();
        this.log_area.add(this.popup);
        this.contentPane.add(this.log_area);
        this.scrollBar = new JScrollPane(this.log_area);
        this.scrollBar.setHorizontalScrollBarPolicy(31);
        this.contentPane.add(this.scrollBar);
        this.tray_icon.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int button = e.getButton();
                int count = e.getClickCount();
                if (button == 1 && count > 1) {
                    instance.setVisible(!instance.isVisible());
                    instance.setExtendedState(0);
                }
            }
        });
        this.log_area.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.showPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.showPopup(e);
            }

            private void showPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    Main.this.popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.setVisible(false);
    }

    private PopupMenu createPopup() {
        PopupMenu popup = new PopupMenu();
        MenuItem popup_update = new MenuItem("Shop aktualisieren");
        MenuItem popup_about = new MenuItem("Info");
        MenuItem popup_xauth = new MenuItem("XAuth erneuern");
        MenuItem popup_settings = new MenuItem("Einstellungen");
        MenuItem popup_show = new MenuItem("Toggle Window");
        MenuItem popup_exit = new MenuItem("Beenden");
        popup.add(popup_update);
        popup.add(popup_about);
        popup.add(popup_xauth);
        popup.add(popup_settings);
        popup.add(popup_show);
        popup.add(popup_exit);
        popup_xauth.addActionListener(action -> new PostXAuthTokenRequestSync());
        popup_update.addActionListener(action -> new UpdateShopTask());
        popup_about.addActionListener(action -> Utils.showInfo());
        popup_show.addActionListener(action -> instance.setVisible(!instance.isVisible()));
        popup_settings.addActionListener(action -> {
            if (this.settings == null) {
                this.settings = new Settings();
            }
            this.settings.setVisible(true);
            this.settings.setExtendedState(0);
        });
        popup_exit.addActionListener(action -> {
            if (!exit) {
                exit = true;
                if (JOptionPane.showConfirmDialog(instance, "Biene wirklich beenden?", "Frage", 0) == 0) {
                    System.exit(0);
                } else {
                    exit = false;
                }
            }
        });
        return popup;
    }

    public void display_tray_message(String title, String message, TrayIcon.MessageType type) {
        if (this.tray_icon != null) {
            this.tray_icon.displayMessage(title, message, type);
        }
    }
}

