/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.biene.http.post;

import com.gmail.berndivader.biene.Logger;
import com.gmail.berndivader.biene.Utils;
import com.gmail.berndivader.biene.enums.Tasks;
import com.gmail.berndivader.biene.http.post.PostTask;
import java.util.HashMap;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.StringBody;
import org.w3c.dom.Document;

public class PostImportCSV
extends PostTask {
    public PostImportCSV(String url, String file_name) {
        super(url);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.addPart("file_name", new StringBody(file_name, ContentType.MULTIPART_FORM_DATA));
        builder.addPart("action", new StringBody(Tasks.HTTP_POST_IMPORT_CSV_FILE.action(), ContentType.MULTIPART_FORM_DATA));
        this.entity = builder.build();
        this.post.setEntity(this.entity);
        this.start();
    }

    public PostImportCSV(String url, HttpEntity entity) {
        super(url, entity);
        this.start();
    }

    @Override
    public void _completed(HttpResponse response) {
        Document xml = Utils.XML.getXMLDocument(response);
        if (xml != null) {
            HashMap<String, String> result = Utils.XML.map(xml);
            Logger.$("CSV-Import von " + (String)result.get("FILE_NAME") + " " + (String)result.get("MESSAGE"), false, true);
            if (result.get("MESSAGE") == null || !((String)result.get("MESSAGE")).equals("OK")) {
                Logger.$("CSV-Import hat mit einem Fehler geantwortet.", false, true);
                Utils.XML.printOut("", xml.getChildNodes());
                this._failed(response);
            }
        } else {
            Logger.$("CSV-Import hat ungew\u00f6hnlich geantwortet.", false, true);
            this._failed(response);
        }
    }

    @Override
    public void _failed(HttpResponse response) {
        this.failed = true;
    }

    @Override
    protected void max_seconds(long max) {
        this.max_seconds = 120L;
    }
}

