/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.biene.command;

import com.gmail.berndivader.biene.Biene;
import com.gmail.berndivader.biene.Logger;
import com.gmail.berndivader.biene.command.Command;
import com.gmail.berndivader.biene.command.CommandAnnotation;
import com.gmail.berndivader.biene.command.commands.Unkown;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class Commands {
    public static Commands instance;
    private static final String PACKAGE_NAME = "com/gmail/berndivader/biene/command/commands";
    private static String fileName;
    public HashMap<String, String> commands = new HashMap();

    public Commands() {
        try {
            this.loadCommandClasses();
        }
        catch (IOException | ClassNotFoundException e) {
            Logger.$("Konsolecommandos konnten nicht geladen werden!");
            Logger.$(e);
        }
    }

    private void loadCommandClasses() throws IOException, ClassNotFoundException {
        try (JarInputStream jarStream = new JarInputStream(new FileInputStream(fileName));){
            while (jarStream.available() == 1) {
                Class<?> clazz;
                CommandAnnotation annotation;
                String className;
                JarEntry entry = jarStream.getNextJarEntry();
                if (entry == null || !(className = entry.getName()).endsWith(".class") || !className.startsWith(PACKAGE_NAME) || (annotation = (clazz = Class.forName(className = className.substring(0, className.length() - 6).replace("/", "."))).getAnnotation(CommandAnnotation.class)) == null) continue;
                this.commands.put(annotation.name(), className);
            }
        }
    }

    public Command getCommand(String name) {
        if (this.commands.containsKey(name)) {
            String className = this.commands.get(name);
            try {
                return (Command)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                Logger.$(String.format("Fehler beim inizialisieren vom Befehl: %s", name));
                Logger.$(e);
            }
        }
        return new Unkown();
    }

    static {
        try {
            fileName = URLDecoder.decode(Biene.class.getProtectionDomain().getCodeSource().getLocation().getPath(), StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            try {
                fileName = URLDecoder.decode(Biene.class.getProtectionDomain().getCodeSource().getLocation().getPath(), StandardCharsets.ISO_8859_1.toString());
            }
            catch (UnsupportedEncodingException e1) {
                Logger.$("Fehler, weder UTF-8 noch ISO-8859 encoding gefunden.");
                Logger.$(e1);
            }
        }
    }
}

