/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.biene.rtf2html;

import com.gmail.berndivader.biene.rtf2html.RtfControlSymbol;
import com.gmail.berndivader.biene.rtf2html.RtfControlWord;
import com.gmail.berndivader.biene.rtf2html.RtfElement;
import com.gmail.berndivader.biene.rtf2html.RtfGroup;
import com.gmail.berndivader.biene.rtf2html.RtfState;
import com.gmail.berndivader.biene.rtf2html.RtfText;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class RtfHtml {
    private String output;
    private Stack<RtfState> states;
    private RtfState state;
    private RtfState previousState;
    private Map<String, Boolean> openedTags;
    private List<String> colortbl;

    public String format(RtfGroup root) {
        return this.format(root, false);
    }

    public String format(RtfGroup root, boolean page) {
        this.previousState = null;
        this.openedTags = new LinkedHashMap<String, Boolean>();
        this.openedTags.put("span", false);
        this.openedTags.put("p", true);
        this.states = new Stack();
        this.state = new RtfState();
        this.states.push(this.state);
        this.output = "<p>";
        this.formatGroup(root);
        if (page) {
            this.wrapTags();
        }
        return this.output;
    }

    protected void extractColorTable(List<RtfElement> colorTblGrp) {
        ArrayList<String> colortbl = new ArrayList<String>();
        colortbl.add(null);
        int c = colorTblGrp.size();
        String color = "";
        for (int i = 2; i < c; ++i) {
            if (colorTblGrp.get(i) instanceof RtfControlWord) {
                int red = ((RtfControlWord)colorTblGrp.get((int)i)).parameter;
                int green = ((RtfControlWord)colorTblGrp.get((int)(i + 1))).parameter;
                int blue = ((RtfControlWord)colorTblGrp.get((int)(i + 2))).parameter;
                color = String.format("#%02x%02x%02x", red, green, blue);
                i += 2;
                continue;
            }
            if (!(colorTblGrp.get(i) instanceof RtfText)) continue;
            colortbl.add(color);
        }
        this.colortbl = colortbl;
    }

    protected void formatGroup(RtfGroup group) {
        if (group == null) {
            return;
        }
        if (group.getType().equals("fonttbl")) {
            return;
        }
        if (group.getType().equals("colortbl")) {
            this.extractColorTable(group.children);
            return;
        }
        if (group.getType().equals("stylesheet")) {
            return;
        }
        if (group.getType().equals("info")) {
            return;
        }
        if (group.getType().length() >= 4 && group.getType().substring(0, 4).equals("pict")) {
            return;
        }
        if (group.isDestination()) {
            return;
        }
        this.state = (RtfState)this.state.clone();
        this.states.push(this.state);
        for (RtfElement child : group.children) {
            if (child instanceof RtfGroup) {
                this.formatGroup((RtfGroup)child);
                continue;
            }
            if (child instanceof RtfControlWord) {
                this.formatControlWord((RtfControlWord)child);
                continue;
            }
            if (child instanceof RtfControlSymbol) {
                this.formatControlSymbol((RtfControlSymbol)child);
                continue;
            }
            if (!(child instanceof RtfText)) continue;
            this.formatText((RtfText)child);
        }
        this.states.pop();
        this.state = this.states.peek();
    }

    protected void formatControlWord(RtfControlWord rtfWord) {
        if (rtfWord.word.equals("plain") || rtfWord.word.equals("pard")) {
            this.state.reset();
        } else if (rtfWord.word.equals("b")) {
            this.state.bold = rtfWord.parameter > 0;
        } else if (rtfWord.word.equals("i")) {
            this.state.italic = rtfWord.parameter > 0;
        } else if (rtfWord.word.equals("ul")) {
            this.state.underline = rtfWord.parameter > 0;
        } else if (rtfWord.word.equals("ulnone")) {
            this.state.underline = false;
        } else if (rtfWord.word.equals("strike")) {
            this.state.strike = rtfWord.parameter > 0;
        } else if (rtfWord.word.equals("v")) {
            this.state.hidden = rtfWord.parameter > 0;
        } else if (rtfWord.word.equals("fs")) {
            this.state.fontSize = (int)Math.ceil((double)rtfWord.parameter / 24.0 * 16.0);
        } else if (rtfWord.word.equals("cf")) {
            this.state.textColor = rtfWord.parameter;
        } else if (rtfWord.word.equals("cb") || rtfWord.word.equals("chcbpat") || rtfWord.word.equals("highlight")) {
            this.state.background = rtfWord.parameter;
        } else if (rtfWord.word.equals("lquote")) {
            this.output = this.output + "&lsquo;";
        } else if (rtfWord.word.equals("rquote")) {
            this.output = this.output + "&rsquo;";
        } else if (rtfWord.word.equals("ldblquote")) {
            this.output = this.output + "&ldquo;";
        } else if (rtfWord.word.equals("rdblquote")) {
            this.output = this.output + "&rdquo;";
        } else if (rtfWord.word.equals("emdash")) {
            this.output = this.output + "&mdash;";
        } else if (rtfWord.word.equals("endash")) {
            this.output = this.output + "&ndash;";
        } else if (rtfWord.word.equals("emspace")) {
            this.output = this.output + "&emsp;";
        } else if (rtfWord.word.equals("enspace")) {
            this.output = this.output + "&ensp;";
        } else if (rtfWord.word.equals("tab")) {
            this.output = this.output + "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
        } else if (rtfWord.word.equals("line")) {
            this.output = this.output + "<br>";
        } else if (rtfWord.word.equals("bullet")) {
            this.output = this.output + "&bull;";
        } else if (rtfWord.word.equals("u")) {
            this.applyStyle("&#" + rtfWord.parameter + ";");
        } else if (rtfWord.word.equals("par") || rtfWord.word.equals("row")) {
            this.closeTags();
            this.output = this.output + "<p>";
            this.openedTags.put("p", true);
        }
    }

    protected void applyStyle(String txt) {
        if (!this.state.equals(this.previousState)) {
            Object span = "";
            if (this.state.bold) {
                span = (String)span + "font-weight:bold;";
            }
            if (this.state.italic) {
                span = (String)span + "font-style:italic;";
            }
            if (this.state.underline) {
                span = (String)span + "text-decoration:underline;";
            }
            if (this.state.strike) {
                span = (String)span + "text-decoration:strikethrough;";
            }
            if (this.state.hidden) {
                span = (String)span + "display:none;";
            }
            this.previousState = (RtfState)this.state.clone();
            this.closeTag("span");
            this.output = this.output + "<span style='" + (String)span + "'>" + txt;
            this.openedTags.put("span", true);
        } else {
            this.output = this.output + txt;
        }
    }

    protected String printColor(int index) {
        return index >= 1 && index < this.colortbl.size() ? this.colortbl.get(index) : "";
    }

    protected void closeTag(String tag) {
        if (this.openedTags.get(tag).booleanValue()) {
            this.output = this.output + "</" + tag + ">";
            this.openedTags.put(tag, false);
        }
    }

    protected void closeTags() {
        for (String tag : this.openedTags.keySet()) {
            this.closeTag(tag);
        }
    }

    protected void wrapTags() {
        StringBuilder source = new StringBuilder();
        source.append(this.output + "\n");
        this.output = source.toString();
    }

    protected void formatControlSymbol(RtfControlSymbol rtfSymbol) {
        if (rtfSymbol.symbol == '\'') {
            this.applyStyle("&#" + rtfSymbol.parameter + ";");
        }
    }

    protected void formatText(RtfText rtfText) {
        this.applyStyle(rtfText.text);
    }
}

