/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.biene.rtf2html;

import com.gmail.berndivader.biene.rtf2html.RtfControlSymbol;
import com.gmail.berndivader.biene.rtf2html.RtfControlWord;
import com.gmail.berndivader.biene.rtf2html.RtfGroup;
import com.gmail.berndivader.biene.rtf2html.RtfParseException;
import com.gmail.berndivader.biene.rtf2html.RtfText;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Collectors;

public class RtfReader {
    private String rtf;
    private int pos;
    private int len;
    private char tchar;
    private RtfGroup group;
    public RtfGroup root = null;

    protected void getChar() {
        if (this.pos < this.rtf.length()) {
            this.tchar = this.rtf.charAt(this.pos++);
        }
    }

    protected int hexdec(String s) {
        return Integer.parseInt(s, 16);
    }

    protected boolean isDigit() {
        return this.tchar >= '0' && this.tchar <= '9';
    }

    protected boolean isLetter() {
        return this.tchar >= 'A' && this.tchar <= 'Z' || this.tchar >= 'a' && this.tchar <= 'z';
    }

    protected void parseStartGroup() {
        RtfGroup newGroup = new RtfGroup();
        if (this.group != null) {
            newGroup.parent = this.group;
        }
        if (this.root == null) {
            this.group = newGroup;
            this.root = newGroup;
        } else {
            this.group.children.add(newGroup);
            this.group = newGroup;
        }
    }

    protected void parseEndGroup() {
        this.group = this.group.parent;
    }

    protected void parseControlWord() {
        this.getChar();
        Object word = "";
        while (this.isLetter()) {
            word = (String)word + this.tchar;
            this.getChar();
        }
        int parameter = -1;
        boolean negative = false;
        if (this.tchar == '-') {
            this.getChar();
            negative = true;
        }
        while (this.isDigit()) {
            if (parameter == -1) {
                parameter = 0;
            }
            parameter = parameter * 10 + Integer.parseInt("" + this.tchar);
            this.getChar();
        }
        if (parameter == -1) {
            parameter = 1;
        }
        if (negative) {
            parameter = -parameter;
        }
        if (((String)word).equals("u")) {
            if (this.tchar == ' ') {
                this.getChar();
            }
            if (this.tchar == '\\' && this.rtf.charAt(this.pos) == '\'') {
                this.pos += 3;
            }
            if (negative) {
                parameter += 65536;
            }
        } else if (this.tchar != ' ') {
            --this.pos;
        }
        RtfControlWord rtfWord = new RtfControlWord();
        rtfWord.word = word;
        rtfWord.parameter = parameter;
        this.group.children.add(rtfWord);
    }

    protected void parseControlSymbol() {
        this.getChar();
        char symbol = this.tchar;
        int parameter = 0;
        if (symbol == '\'') {
            this.getChar();
            String firstChar = "" + this.tchar;
            this.getChar();
            String secondChar = "" + this.tchar;
            parameter = this.hexdec(firstChar + secondChar);
        }
        RtfControlSymbol rtfSymbol = new RtfControlSymbol();
        rtfSymbol.symbol = symbol;
        rtfSymbol.parameter = parameter;
        this.group.children.add(rtfSymbol);
    }

    protected void parseControl() {
        this.getChar();
        --this.pos;
        if (this.isLetter()) {
            this.parseControlWord();
        } else {
            this.parseControlSymbol();
        }
    }

    protected void parseText() throws RtfParseException {
        Object text = "";
        boolean terminate = false;
        do {
            terminate = false;
            if (this.tchar == '\\') {
                this.getChar();
                switch (this.tchar) {
                    case '\\': 
                    case '{': 
                    case '}': {
                        break;
                    }
                    default: {
                        this.pos -= 2;
                        terminate = true;
                        break;
                    }
                }
            } else if (this.tchar == '{' || this.tchar == '}') {
                --this.pos;
                terminate = true;
            }
            if (terminate) continue;
            text = (String)text + this.tchar;
            this.getChar();
        } while (!terminate && this.pos < this.len);
        RtfText rtfText = new RtfText();
        rtfText.text = text;
        if (this.group != null) {
            this.group.children.add(rtfText);
        }
    }

    public boolean isValid(String rtf_string) {
        return rtf_string.contains("{\\rtf1");
    }

    public void parse(File rtfFile) throws RtfParseException {
        try (FileInputStream fis = new FileInputStream(rtfFile);){
            this.parse(fis);
        }
        catch (IOException e) {
            throw new RtfParseException(e.getMessage());
        }
    }

    public void parse(InputStream rtfStream) throws RtfParseException {
        String rtfSource = new BufferedReader(new InputStreamReader(rtfStream)).lines().collect(Collectors.joining("\n"));
        this.parse(rtfSource);
    }

    public void parse(String rtfSource) throws RtfParseException {
        this.rtf = rtfSource;
        this.pos = 0;
        this.len = this.rtf.length();
        this.group = null;
        this.root = null;
        block5: while (this.pos < this.len) {
            this.getChar();
            if (this.tchar == '\n' || this.tchar == '\r') continue;
            switch (this.tchar) {
                case '{': {
                    this.parseStartGroup();
                    continue block5;
                }
                case '}': {
                    this.parseEndGroup();
                    continue block5;
                }
                case '\\': {
                    this.parseControl();
                    continue block5;
                }
            }
            this.parseText();
        }
    }
}

