/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.heewhomee;

import com.gmail.berndivader.heewhomee.HeeWhooMee;
import com.gmail.berndivader.heewhomee.Helper;
import com.gmail.berndivader.heewhomee.consolecommand.Command;
import java.lang.reflect.InvocationTargetException;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;

public class Console
implements Runnable {
    private static final Scanner keyboard = new Scanner(System.in);

    public Console() {
        Helper.scheduler.scheduleAtFixedRate(this, 5L, 5L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void run() {
        Console.prompt();
        String input = keyboard.nextLine();
        if (!input.isBlank() && input.startsWith(".")) {
            String[] args2 = input.split(" ", 2);
            String cmd = args2[0];
            if (!Command.hasCommand(cmd)) {
                Console.err("UNKNOWN COMMAND: ".concat(input), null);
                return;
            }
            String arg = "";
            if (args2.length == 2) {
                arg = args2[1];
            }
            try {
                Command command = Command.getCommand(cmd).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                command.execute(arg);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                Console.err("ERROR with CMD: ".concat(cmd.concat(" - with message:")).concat(e.getMessage()), e);
            }
        }
    }

    public static void out(String output) {
        Console.out(output, false);
    }

    public static void err(String output, Exception e) {
        Console.err(output, false, e);
    }

    public static void out(String output, boolean prompt) {
        if (output != null) {
            System.out.println(output);
        }
        if (prompt) {
            Console.prompt();
        }
    }

    public static void err(String output, boolean prompt, Exception e) {
        if (output != null) {
            System.err.println(output);
        }
        if (HeeWhooMee.debug && e != null) {
            e.printStackTrace();
        }
        if (prompt) {
            Console.prompt();
        }
    }

    public static void prompt() {
        System.out.print("$ ");
    }
}

