/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.filter;

import com.sedmelluq.discord.lavaplayer.filter.AudioPostProcessor;
import com.sedmelluq.discord.lavaplayer.filter.UniversalPcmAudioFilter;
import com.sedmelluq.discord.lavaplayer.format.AudioDataFormat;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinalPcmAudioFilter
implements UniversalPcmAudioFilter {
    private static final Logger log = LoggerFactory.getLogger(FinalPcmAudioFilter.class);
    private static final short[] zeroPadding = new short[128];
    private final AudioDataFormat format;
    private final ShortBuffer frameBuffer;
    private final Collection<AudioPostProcessor> postProcessors;
    private long ignoredFrames;
    private long timecodeBase;
    private long timecodeSampleOffset;

    public FinalPcmAudioFilter(AudioProcessingContext context, Collection<AudioPostProcessor> postProcessors) {
        this.format = context.outputFormat;
        this.frameBuffer = ByteBuffer.allocateDirect(this.format.totalSampleCount() * 2).order(ByteOrder.nativeOrder()).asShortBuffer();
        this.postProcessors = postProcessors;
        this.timecodeBase = 0L;
        this.timecodeSampleOffset = 0L;
    }

    private short decodeSample(float sample) {
        return (short)Math.min(Math.max((int)(sample * 32768.0f), Short.MIN_VALUE), Short.MAX_VALUE);
    }

    @Override
    public void seekPerformed(long requestedTime, long providedTime) {
        this.frameBuffer.clear();
        this.ignoredFrames = requestedTime > providedTime ? (requestedTime - providedTime) * (long)this.format.channelCount * (long)this.format.sampleRate / 1000L : 0L;
        this.timecodeBase = Math.max(requestedTime, providedTime);
        this.timecodeSampleOffset = 0L;
        if (this.ignoredFrames > 0L) {
            log.debug("Ignoring {} frames due to inaccurate seek (requested {}, provided {}).", this.ignoredFrames, requestedTime, providedTime);
        }
    }

    @Override
    public void flush() throws InterruptedException {
        if (this.frameBuffer.position() > 0) {
            this.fillFrameBuffer();
            this.dispatch();
        }
    }

    @Override
    public void close() {
        for (AudioPostProcessor postProcessor : this.postProcessors) {
            postProcessor.close();
        }
    }

    private void fillFrameBuffer() {
        while (this.frameBuffer.remaining() >= zeroPadding.length) {
            this.frameBuffer.put(zeroPadding);
        }
        while (this.frameBuffer.remaining() > 0) {
            this.frameBuffer.put((short)0);
        }
    }

    @Override
    public void process(short[] input, int offset, int length) throws InterruptedException {
        for (int i = 0; i < length; ++i) {
            if (this.ignoredFrames > 0L) {
                --this.ignoredFrames;
                continue;
            }
            this.frameBuffer.put(input[offset + i]);
            this.dispatch();
        }
    }

    @Override
    public void process(short[][] input, int offset, int length) throws InterruptedException {
        int secondChannelIndex = Math.min(1, input.length - 1);
        for (int i = 0; i < length; ++i) {
            if (this.ignoredFrames > 0L) {
                this.ignoredFrames -= (long)this.format.channelCount;
                continue;
            }
            this.frameBuffer.put(input[0][offset + i]);
            this.frameBuffer.put(input[secondChannelIndex][offset + i]);
            this.dispatch();
        }
    }

    @Override
    public void process(ShortBuffer buffer) throws InterruptedException {
        if (this.ignoredFrames > 0L) {
            long skipped = Math.min((long)buffer.remaining(), this.ignoredFrames);
            buffer.position(buffer.position() + (int)skipped);
            this.ignoredFrames -= skipped;
        }
        ShortBuffer local = buffer.duplicate();
        while (buffer.remaining() > 0) {
            int chunk = Math.min(buffer.remaining(), this.frameBuffer.remaining());
            local.position(buffer.position());
            local.limit(local.position() + chunk);
            this.frameBuffer.put(local);
            this.dispatch();
            buffer.position(buffer.position() + chunk);
        }
    }

    @Override
    public void process(float[][] buffer, int offset, int length) throws InterruptedException {
        int secondChannelIndex = Math.min(1, buffer.length - 1);
        for (int i = 0; i < length; ++i) {
            if (this.ignoredFrames > 0L) {
                this.ignoredFrames -= 2L;
                continue;
            }
            this.frameBuffer.put(this.decodeSample(buffer[0][offset + i]));
            this.frameBuffer.put(this.decodeSample(buffer[secondChannelIndex][offset + i]));
            this.dispatch();
        }
    }

    private void dispatch() throws InterruptedException {
        if (!this.frameBuffer.hasRemaining()) {
            long timecode = this.timecodeBase + this.timecodeSampleOffset * 1000L / (long)this.format.sampleRate;
            this.frameBuffer.clear();
            for (AudioPostProcessor postProcessor : this.postProcessors) {
                postProcessor.process(timecode, this.frameBuffer);
            }
            this.frameBuffer.clear();
            this.timecodeSampleOffset += (long)this.format.chunkSampleCount;
        }
    }
}

