/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event;

import discord4j.common.LogUtil;
import discord4j.core.event.DefaultEventDispatcher;
import discord4j.core.event.EventDispatcher;
import discord4j.core.event.domain.Event;
import discord4j.core.event.domain.guild.GuildCreateEvent;
import discord4j.core.event.domain.lifecycle.GatewayLifecycleEvent;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.publisher.EmitterProcessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxProcessor;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.core.publisher.ReplayProcessor;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.concurrent.Queues;

public class ReplayingEventDispatcher
implements EventDispatcher {
    private static final Logger log = Loggers.getLogger(ReplayingEventDispatcher.class);
    private final FluxProcessor<Event, Event> eventProcessor;
    private final FluxSink<Event> sink;
    private final Scheduler eventScheduler;
    private final ReplayProcessor<Event> replayEventProcessor;
    private final FluxSink<Event> replaySink;
    private final Predicate<Event> replayEventFilter;
    private final Scheduler timedTaskScheduler;
    private final Publisher<?> stopReplayingTrigger;
    private final AtomicReference<State> state = new AtomicReference<State>(State.REPLAY);

    public ReplayingEventDispatcher(FluxProcessor<Event, Event> eventProcessor, FluxSink.OverflowStrategy overflowStrategy, Scheduler eventScheduler, ReplayProcessor<Event> replayEventProcessor, FluxSink.OverflowStrategy replayEventOverflowStrategy, Predicate<Event> replayEventFilter, Scheduler timedTaskScheduler, Publisher<?> stopReplayingTrigger) {
        this.eventProcessor = eventProcessor;
        this.sink = eventProcessor.sink(overflowStrategy);
        this.eventScheduler = eventScheduler;
        this.replayEventProcessor = replayEventProcessor;
        this.replaySink = replayEventProcessor.sink(replayEventOverflowStrategy);
        this.replayEventFilter = replayEventFilter;
        this.timedTaskScheduler = timedTaskScheduler;
        this.stopReplayingTrigger = stopReplayingTrigger;
    }

    @Override
    public <E extends Event> Flux<E> on(Class<E> eventClass) {
        AtomicReference subscription = new AtomicReference();
        return this.eventProcessor.publishOn(this.eventScheduler).startWith(this.replayEventProcessor.timeout(Duration.ofMillis(1L), Mono.empty(), this.timedTaskScheduler)).ofType(eventClass).handle((event, sink) -> {
            if (log.isTraceEnabled()) {
                log.trace(LogUtil.format(sink.currentContext().put("discord4j.shard", event.getShardInfo().getIndex()), "{}"), event.toString());
            }
            sink.next(event);
        }).doOnSubscribe(sub -> {
            subscription.set(sub);
            if (log.isDebugEnabled()) {
                log.debug("Subscription {} to {} created", Integer.toHexString(sub.hashCode()), eventClass.getSimpleName());
            }
        }).doFinally(signal -> {
            if (log.isDebugEnabled()) {
                log.debug("Subscription {} to {} disposed due to {}", Integer.toHexString(((Subscription)subscription.get()).hashCode()), eventClass.getSimpleName(), signal);
            }
        });
    }

    @Override
    public void publish(Event event) {
        if (this.state.get() != State.EMIT && this.replayEventFilter.test(event)) {
            this.replaySink.next(event);
        }
        if (this.eventProcessor.hasDownstreams()) {
            if (this.state.compareAndSet(State.REPLAY, State.REPLAY_EMIT)) {
                Flux.from(this.stopReplayingTrigger).doFinally(__ -> this.state.set(State.EMIT)).subscribe();
            }
            this.sink.next(event);
        } else if (this.state.compareAndSet(State.EMIT, State.REPLAY) && this.replayEventFilter.test(event)) {
            log.warn("All subscribers have disconnected from this dispatcher");
            this.replaySink.next(event);
        }
    }

    @Override
    public void shutdown() {
        this.replaySink.complete();
        this.sink.complete();
    }

    public static EventDispatcher create() {
        return ReplayingEventDispatcher.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends DefaultEventDispatcher.Builder {
        protected Predicate<Event> replayEventFilter = event -> event instanceof GatewayLifecycleEvent || event instanceof GuildCreateEvent;
        protected Scheduler timedTaskScheduler = Schedulers.parallel();
        protected ReplayProcessor<Event> replayEventProcessor;
        protected FluxSink.OverflowStrategy replayEventOverflowStrategy = FluxSink.OverflowStrategy.DROP;
        protected Publisher<?> stopReplayingTrigger;

        protected Builder() {
        }

        @Override
        public Builder eventProcessor(FluxProcessor<Event, Event> eventProcessor) {
            this.eventProcessor = Objects.requireNonNull(eventProcessor);
            return this;
        }

        @Override
        public Builder overflowStrategy(FluxSink.OverflowStrategy overflowStrategy) {
            this.overflowStrategy = Objects.requireNonNull(overflowStrategy);
            return this;
        }

        @Override
        public Builder eventScheduler(Scheduler eventScheduler) {
            this.eventScheduler = Objects.requireNonNull(eventScheduler);
            return this;
        }

        public Builder replayEventProcessor(ReplayProcessor<Event> replayEventProcessor) {
            this.replayEventProcessor = Objects.requireNonNull(replayEventProcessor);
            return this;
        }

        public Builder replayEventOverflowStrategy(FluxSink.OverflowStrategy replayEventOverflowStrategy) {
            this.replayEventOverflowStrategy = Objects.requireNonNull(replayEventOverflowStrategy);
            return this;
        }

        public Builder replayEventFilter(Predicate<Event> replayEventFilter) {
            this.replayEventFilter = Objects.requireNonNull(replayEventFilter);
            return this;
        }

        public Builder timedTaskScheduler(Scheduler timedTaskScheduler) {
            this.timedTaskScheduler = Objects.requireNonNull(timedTaskScheduler);
            return this;
        }

        public Builder stopReplayingTrigger(Publisher<?> stopReplayingTrigger) {
            this.stopReplayingTrigger = Objects.requireNonNull(stopReplayingTrigger);
            return this;
        }

        @Override
        public EventDispatcher build() {
            if (this.eventProcessor == null) {
                this.eventProcessor = EmitterProcessor.create(Queues.SMALL_BUFFER_SIZE, false);
            }
            if (this.eventScheduler == null) {
                this.eventScheduler = EventDispatcher.DEFAULT_EVENT_SCHEDULER.get();
            }
            if (this.timedTaskScheduler == null) {
                this.timedTaskScheduler = Schedulers.parallel();
            }
            if (this.replayEventProcessor == null) {
                this.replayEventProcessor = ReplayProcessor.createTimeout(Duration.ofMinutes(2L), this.timedTaskScheduler);
            }
            if (this.stopReplayingTrigger == null) {
                this.stopReplayingTrigger = Mono.delay(Duration.ofSeconds(5L), this.timedTaskScheduler);
            }
            return new ReplayingEventDispatcher(this.eventProcessor, this.overflowStrategy, this.eventScheduler, this.replayEventProcessor, this.replayEventOverflowStrategy, this.replayEventFilter, this.timedTaskScheduler, this.stopReplayingTrigger);
        }
    }

    private static enum State {
        REPLAY,
        REPLAY_EMIT,
        EMIT;

    }
}

