/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.ffprobe.data;

import com.github.kokorin.jaffree.JaffreeException;
import com.github.kokorin.jaffree.ffprobe.data.AbstractProbeData;
import com.github.kokorin.jaffree.ffprobe.data.FormatParser;
import com.github.kokorin.jaffree.ffprobe.data.ProbeData;
import com.grack.nanojson.JsonArray;
import com.grack.nanojson.JsonObject;
import com.grack.nanojson.JsonParser;
import com.grack.nanojson.JsonParserException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class JsonFormatParser
implements FormatParser {
    @Override
    public String getFormatName() {
        return "json";
    }

    @Override
    public ProbeData parse(InputStream inputStream) {
        JsonObject jsonObject;
        try {
            jsonObject = JsonParser.object().from(inputStream);
        }
        catch (JsonParserException e) {
            throw new JaffreeException("Failed to parse JSON output", e);
        }
        return new ProbeDataJson(jsonObject);
    }

    private static final class ProbeDataJson
    extends AbstractProbeData
    implements ProbeData {
        private final JsonObject data;

        private ProbeDataJson(JsonObject data) {
            this.data = data;
        }

        @Override
        public Object getValue(String name) {
            if (this.data == null) {
                return null;
            }
            return this.data.get(name);
        }

        @Override
        public List<ProbeData> getSubDataList(String name) {
            if (this.data == null) {
                return null;
            }
            JsonArray jsonArray = this.data.getArray(name);
            if (jsonArray == null) {
                return null;
            }
            ArrayList<ProbeData> result = new ArrayList<ProbeData>(jsonArray.size());
            for (int i = 0; i < jsonArray.size(); ++i) {
                result.add(new ProbeDataJson(jsonArray.getObject(i)));
            }
            return result;
        }

        @Override
        public ProbeData getSubData(String name) {
            if (this.data == null) {
                return null;
            }
            JsonObject subData = this.data.getObject(name);
            if (subData == null) {
                return null;
            }
            return new ProbeDataJson(subData);
        }
    }
}

