/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.ffmpeg;

import com.github.kokorin.jaffree.LogLevel;
import com.github.kokorin.jaffree.StreamType;
import com.github.kokorin.jaffree.ffmpeg.BaseInOut;
import com.github.kokorin.jaffree.ffmpeg.FFmpegProgressReader;
import com.github.kokorin.jaffree.ffmpeg.FFmpegResult;
import com.github.kokorin.jaffree.ffmpeg.FFmpegResultFuture;
import com.github.kokorin.jaffree.ffmpeg.FFmpegResultReader;
import com.github.kokorin.jaffree.ffmpeg.FFmpegStopper;
import com.github.kokorin.jaffree.ffmpeg.Filter;
import com.github.kokorin.jaffree.ffmpeg.FilterChain;
import com.github.kokorin.jaffree.ffmpeg.FilterGraph;
import com.github.kokorin.jaffree.ffmpeg.Input;
import com.github.kokorin.jaffree.ffmpeg.Output;
import com.github.kokorin.jaffree.ffmpeg.OutputListener;
import com.github.kokorin.jaffree.ffmpeg.ProgressListener;
import com.github.kokorin.jaffree.net.NegotiatingTcpServer;
import com.github.kokorin.jaffree.process.LoggingStdReader;
import com.github.kokorin.jaffree.process.ProcessHandler;
import com.github.kokorin.jaffree.process.ProcessHelper;
import com.github.kokorin.jaffree.process.StdReader;
import com.github.kokorin.jaffree.process.Stopper;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FFmpeg {
    private final List<Input> inputs = new ArrayList<Input>();
    private final List<Output> outputs = new ArrayList<Output>();
    private final List<String> additionalArguments = new ArrayList<String>();
    private boolean overwriteOutput;
    private ProgressListener progressListener;
    private OutputListener outputListener;
    private String progress;
    private String complexFilter;
    private final Map<String, Object> filters = new HashMap<String, Object>();
    private LogLevel logLevel = LogLevel.INFO;
    private String contextName = null;
    private Integer executorTimeoutMillis = null;
    private final Path executable;
    private static final Logger LOGGER = LoggerFactory.getLogger(FFmpeg.class);

    public FFmpeg(Path executable) {
        this.executable = executable;
    }

    public FFmpeg addInput(Input input) {
        this.inputs.add(input);
        return this;
    }

    public FFmpeg addOutput(Output output) {
        this.outputs.add(output);
        return this;
    }

    public FFmpeg addArgument(String argument) {
        this.additionalArguments.add(argument);
        return this;
    }

    public FFmpeg addArguments(String key, String value) {
        this.additionalArguments.addAll(Arrays.asList(key, value));
        return this;
    }

    public FFmpeg setComplexFilter(FilterGraph complexFilter) {
        return this.setComplexFilter(complexFilter.getValue());
    }

    public FFmpeg setComplexFilter(String complexFilter) {
        this.complexFilter = complexFilter;
        return this;
    }

    public FFmpeg setFilter(Filter filter) {
        return this.setFilter(filter.getValue());
    }

    public FFmpeg setFilter(FilterChain filterChain) {
        return this.setFilter(filterChain.getValue());
    }

    public FFmpeg setFilter(String filter) {
        return this.setFilter((String)null, filter);
    }

    public FFmpeg setFilter(StreamType streamType, Filter filter) {
        return this.setFilter(streamType, filter.getValue());
    }

    public FFmpeg setFilter(StreamType streamType, FilterChain filterChain) {
        return this.setFilter(streamType, filterChain.getValue());
    }

    public FFmpeg setFilter(StreamType streamType, String filter) {
        return this.setFilter(streamType.code(), filter);
    }

    public FFmpeg setFilter(String streamSpecifier, Filter filter) {
        return this.setFilter(streamSpecifier, filter.getValue());
    }

    public FFmpeg setFilter(String streamSpecifier, FilterChain filterChain) {
        return this.setFilter(streamSpecifier, filterChain.getValue());
    }

    public FFmpeg setFilter(String streamSpecifier, String filter) {
        this.filters.put(streamSpecifier, filter);
        return this;
    }

    public FFmpeg setOverwriteOutput(boolean overwriteOutput) {
        this.overwriteOutput = overwriteOutput;
        return this;
    }

    public FFmpeg setProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener;
        return this;
    }

    public FFmpeg setOutputListener(OutputListener outputListener) {
        this.outputListener = outputListener;
        return this;
    }

    protected void setProgress(String progress) {
        this.progress = progress;
    }

    public FFmpeg setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    public FFmpeg setContextName(String contextName) {
        this.contextName = contextName;
        return this;
    }

    public FFmpeg setExecutorTimeoutMillis(int executorTimeoutMillis) {
        if (executorTimeoutMillis < 0) {
            throw new IllegalArgumentException("Executor timeout cannot be negative");
        }
        this.executorTimeoutMillis = executorTimeoutMillis;
        return this;
    }

    public FFmpegResult execute() {
        return this.createProcessHandler().setStopper(this.createStopper()).execute();
    }

    public FFmpegResultFuture executeAsync() {
        return this.executeAsync(new Executor(){

            @Override
            public void execute(Runnable command) {
                Thread runner = new Thread(command, "FFmpeg-async-runner");
                runner.setDaemon(true);
                runner.start();
            }
        });
    }

    public FFmpegResultFuture executeAsync(Executor executor) {
        final ProcessHandler<FFmpegResult> processHandler = this.createProcessHandler();
        final Stopper stopper = this.createStopper();
        processHandler.setStopper(stopper);
        final CompletableFuture<FFmpegResult> resultFuture = new CompletableFuture<FFmpegResult>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                if (mayInterruptIfRunning) {
                    stopper.forceStop();
                } else {
                    stopper.graceStop();
                }
                return this.completeExceptionally(new CancellationException());
            }
        };
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    resultFuture.complete((FFmpegResult)processHandler.execute());
                }
                catch (Throwable error) {
                    resultFuture.completeExceptionally(error);
                }
            }
        });
        return new FFmpegResultFuture(resultFuture, stopper);
    }

    protected ProcessHandler<FFmpegResult> createProcessHandler() {
        ProcessHelper helper;
        ArrayList<ProcessHelper> helpers = new ArrayList<ProcessHelper>();
        for (Input input : this.inputs) {
            helper = input.helperThread();
            if (helper == null) continue;
            helpers.add(helper);
        }
        for (Output output : this.outputs) {
            helper = output.helperThread();
            if (helper == null) continue;
            helpers.add(helper);
        }
        ProcessHelper progressHelper = this.createProgressHelper(this.progressListener);
        if (progressHelper != null) {
            helpers.add(progressHelper);
        }
        ProcessHandler<FFmpegResult> processHandler = new ProcessHandler<FFmpegResult>(this.executable, this.contextName).setStdErrReader(this.createStdErrReader(this.outputListener)).setStdOutReader(this.createStdOutReader()).setHelpers(helpers).setArguments(this.buildArguments());
        if (this.executorTimeoutMillis != null) {
            processHandler.setExecutorTimeoutMillis(this.executorTimeoutMillis);
        }
        return processHandler;
    }

    protected Stopper createStopper() {
        return new FFmpegStopper();
    }

    protected StdReader<FFmpegResult> createStdErrReader(OutputListener listener) {
        return new FFmpegResultReader(listener);
    }

    protected StdReader<FFmpegResult> createStdOutReader() {
        return new LoggingStdReader<FFmpegResult>();
    }

    protected ProcessHelper createProgressHelper(ProgressListener listener) {
        NegotiatingTcpServer result = null;
        String progressReportUrl = null;
        if (listener != null) {
            result = NegotiatingTcpServer.onRandomPort(new FFmpegProgressReader(listener));
            progressReportUrl = "tcp://" + result.getAddressAndPort();
        }
        this.setProgress(progressReportUrl);
        return result;
    }

    protected List<String> buildArguments() {
        ArrayList<String> result = new ArrayList<String>();
        String logLevelArgument = "level";
        if (this.logLevel != null) {
            logLevelArgument = logLevelArgument + "+" + this.logLevel.name().toLowerCase();
        }
        result.addAll(Arrays.asList("-loglevel", logLevelArgument));
        for (Input input : this.inputs) {
            result.addAll(input.buildArguments());
        }
        if (this.overwriteOutput) {
            result.add("-y");
        } else {
            result.add("-n");
        }
        if (this.progress != null) {
            result.addAll(Arrays.asList("-progress", this.progress));
        } else {
            LOGGER.warn("ProgressListener isn't set, progress won't be reported");
        }
        if (this.complexFilter != null) {
            result.addAll(Arrays.asList("-filter_complex", this.complexFilter));
        }
        result.addAll(BaseInOut.toArguments("-filter", this.filters));
        result.addAll(this.additionalArguments);
        for (Output output : this.outputs) {
            result.addAll(output.buildArguments());
        }
        return result;
    }

    public static FFmpeg atPath() {
        return FFmpeg.atPath(null);
    }

    public static FFmpeg atPath(Path pathToDir) {
        Path executable = pathToDir != null ? pathToDir.resolve("ffmpeg") : Paths.get("ffmpeg", new String[0]);
        return new FFmpeg(executable);
    }
}

