/*
 * Decompiled with CFR 0.152.
 */
package discord4j.common.store.impl;

import discord4j.discordjson.Id;
import discord4j.discordjson.json.PresenceData;
import discord4j.discordjson.json.gateway.PresenceUpdate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import reactor.util.annotation.Nullable;

class ImplUtils {
    ImplUtils() {
    }

    static <T> void ifNonNullDo(@Nullable T val, Consumer<? super T> action) {
        if (val != null) {
            action.accept(val);
        }
    }

    @Nullable
    static <T, R> R ifNonNullMap(@Nullable T val, Function<? super T, ? extends R> mapper) {
        if (val != null) {
            return mapper.apply(val);
        }
        return null;
    }

    static <T> Optional<T> or(Optional<T> first, Supplier<Optional<T>> supplier) {
        Objects.requireNonNull(supplier);
        if (first.isPresent()) {
            return first;
        }
        Optional<T> r = supplier.get();
        return Objects.requireNonNull(r);
    }

    static PresenceData createPresence(PresenceUpdate update) {
        return PresenceData.builder().user(update.user()).status(update.status()).activities(update.activities()).clientStatus(update.clientStatus()).build();
    }

    static <T> List<T> add(List<T> list, T element) {
        return Stream.concat(list.stream(), Stream.of(element)).collect(Collectors.toList());
    }

    static <T> List<T> remove(List<T> list, T element) {
        return list.stream().filter(x -> !x.equals(element)).collect(Collectors.toList());
    }

    static List<Id> removeAllIds(List<Id> list, Set<Long> elements) {
        return list.stream().filter(x -> !elements.contains(x.asLong())).collect(Collectors.toList());
    }
}

