/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.core.spec.BanQuerySpecGenerator;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="BanQuerySpecGenerator", generator="Immutables")
public final class BanQuerySpec
implements BanQuerySpecGenerator {
    @Nullable
    private final String reason;
    @Nullable
    private final Integer deleteMessageSeconds;
    @Nullable
    private final Integer deleteMessageDays;
    private static final BanQuerySpec INSTANCE = BanQuerySpec.validate(new BanQuerySpec());

    private BanQuerySpec() {
        this.reason = null;
        this.deleteMessageSeconds = null;
        this.deleteMessageDays = null;
    }

    private BanQuerySpec(@Nullable String reason, @Nullable Integer deleteMessageSeconds, @Nullable Integer deleteMessageDays) {
        this.reason = reason;
        this.deleteMessageSeconds = deleteMessageSeconds;
        this.deleteMessageDays = deleteMessageDays;
    }

    @Override
    @Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    @Nullable
    public Integer deleteMessageSeconds() {
        return this.deleteMessageSeconds;
    }

    @Override
    @Deprecated
    @Nullable
    public Integer deleteMessageDays() {
        return this.deleteMessageDays;
    }

    public final BanQuerySpec withReason(@Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return BanQuerySpec.validate(new BanQuerySpec(value, this.deleteMessageSeconds, this.deleteMessageDays));
    }

    public final BanQuerySpec withDeleteMessageSeconds(@Nullable Integer value) {
        if (Objects.equals(this.deleteMessageSeconds, value)) {
            return this;
        }
        return BanQuerySpec.validate(new BanQuerySpec(this.reason, value, this.deleteMessageDays));
    }

    @Deprecated
    public final BanQuerySpec withDeleteMessageDays(@Nullable Integer value) {
        if (Objects.equals(this.deleteMessageDays, value)) {
            return this;
        }
        return BanQuerySpec.validate(new BanQuerySpec(this.reason, this.deleteMessageSeconds, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BanQuerySpec && this.equalTo(0, (BanQuerySpec)another);
    }

    private boolean equalTo(int synthetic, BanQuerySpec another) {
        return Objects.equals(this.reason, another.reason) && Objects.equals(this.deleteMessageSeconds, another.deleteMessageSeconds) && Objects.equals(this.deleteMessageDays, another.deleteMessageDays);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.reason);
        h2 += (h2 << 5) + Objects.hashCode(this.deleteMessageSeconds);
        h2 += (h2 << 5) + Objects.hashCode(this.deleteMessageDays);
        return h2;
    }

    public String toString() {
        return "BanQuerySpec{reason=" + this.reason + ", deleteMessageSeconds=" + this.deleteMessageSeconds + ", deleteMessageDays=" + this.deleteMessageDays + "}";
    }

    public static BanQuerySpec create() {
        return INSTANCE;
    }

    private static BanQuerySpec validate(BanQuerySpec instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    static BanQuerySpec copyOf(BanQuerySpecGenerator instance) {
        if (instance instanceof BanQuerySpec) {
            return (BanQuerySpec)instance;
        }
        return BanQuerySpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="BanQuerySpecGenerator", generator="Immutables")
    public static final class Builder {
        private String reason;
        private Integer deleteMessageSeconds;
        private Integer deleteMessageDays;

        private Builder() {
        }

        public final Builder from(BanQuerySpec instance) {
            return this.from((BanQuerySpecGenerator)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(BanQuerySpecGenerator instance) {
            Integer deleteMessageDaysValue;
            Integer deleteMessageSecondsValue;
            Objects.requireNonNull(instance, "instance");
            String reasonValue = instance.reason();
            if (reasonValue != null) {
                this.reason(reasonValue);
            }
            if ((deleteMessageSecondsValue = instance.deleteMessageSeconds()) != null) {
                this.deleteMessageSeconds(deleteMessageSecondsValue);
            }
            if ((deleteMessageDaysValue = instance.deleteMessageDays()) != null) {
                this.deleteMessageDays(deleteMessageDaysValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reason(@Nullable String reason) {
            this.reason = reason;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder deleteMessageSeconds(@Nullable Integer deleteMessageSeconds) {
            this.deleteMessageSeconds = deleteMessageSeconds;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder deleteMessageDays(@Nullable Integer deleteMessageDays) {
            this.deleteMessageDays = deleteMessageDays;
            return this;
        }

        public BanQuerySpec build() {
            return BanQuerySpec.validate(new BanQuerySpec(this.reason, this.deleteMessageSeconds, this.deleteMessageDays));
        }
    }
}

