/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.util;

import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.Entity;
import discord4j.core.object.entity.Role;
import discord4j.core.object.entity.channel.CategorizableChannel;
import discord4j.core.object.entity.channel.Category;
import discord4j.core.object.entity.channel.GuildChannel;
import discord4j.core.object.entity.channel.VoiceChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import reactor.core.publisher.Flux;

public final class OrderUtil {
    public static final Comparator<Role> ROLE_ORDER = Comparator.comparing(Role::getRawPosition).thenComparing(Role::getId);
    public static final Comparator<GuildChannel> CHANNEL_ORDER = Comparator.comparing(GuildChannel::getRawPosition).thenComparing(Entity::getId);
    public static final Comparator<CategorizableChannel> BUCKETED_CHANNEL_ORDER = Comparator.comparingInt(c -> {
        if (c instanceof VoiceChannel) {
            return 1;
        }
        return 0;
    }).thenComparing(CHANNEL_ORDER);

    public static Flux<GuildChannel> orderGuildChannels(Flux<GuildChannel> channels) {
        return channels.collectMap(Entity::getId).flatMapIterable(OrderUtil::orderGuildChannels);
    }

    public static Flux<Role> orderRoles(Flux<Role> roles) {
        return roles.sort(ROLE_ORDER);
    }

    private static List<GuildChannel> orderGuildChannels(Map<Snowflake, GuildChannel> channels) {
        TreeMap<GuildChannel, SortedSet> byCategory = new TreeMap<GuildChannel, SortedSet>(Comparator.nullsFirst(CHANNEL_ORDER));
        channels.forEach((id, channel) -> {
            if (channel instanceof CategorizableChannel) {
                CategorizableChannel categorizable = (CategorizableChannel)channel;
                Category parent = (Category)channels.get(categorizable.getCategoryId().orElse(null));
                byCategory.computeIfAbsent(parent, __ -> new TreeSet<CategorizableChannel>(BUCKETED_CHANNEL_ORDER)).add(categorizable);
            } else {
                byCategory.putIfAbsent((Category)channel, new TreeSet<CategorizableChannel>(BUCKETED_CHANNEL_ORDER));
            }
        });
        ArrayList<GuildChannel> sorted = new ArrayList<GuildChannel>();
        byCategory.forEach((category, children) -> {
            if (category != null) {
                sorted.add((GuildChannel)category);
            }
            sorted.addAll((Collection<GuildChannel>)children);
        });
        return sorted;
    }
}

