/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.http;

import discord4j.rest.http.WriterStrategy;
import io.netty.buffer.ByteBufAllocator;
import java.nio.charset.StandardCharsets;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufFlux;
import reactor.netty.http.client.HttpClient;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;

public class FormUrlEncodedWriterStrategy
implements WriterStrategy<String> {
    private static final Logger log = Loggers.getLogger(FormUrlEncodedWriterStrategy.class);

    @Override
    public boolean canWrite(@Nullable Class<?> type, @Nullable String contentType) {
        return type != null && contentType != null && contentType.startsWith("application/x-www-form-urlencoded") && String.class.isAssignableFrom(type);
    }

    @Override
    public Mono<HttpClient.ResponseReceiver<?>> write(HttpClient.RequestSender sender, @Nullable String body) {
        if (body == null) {
            return Mono.error(new RuntimeException("Missing body"));
        }
        Mono<String> source = Mono.just(body).doOnNext(payload -> {
            if (log.isTraceEnabled()) {
                log.trace("{}", body);
            }
        });
        return Mono.fromCallable(() -> sender.send(ByteBufFlux.fromString(source, StandardCharsets.UTF_8, ByteBufAllocator.DEFAULT)));
    }
}

