/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.StickerData;
import discord4j.discordjson.json.StickerPackData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;

@Generated(from="StickerPackData", generator="Immutables")
public final class ImmutableStickerPackData
implements StickerPackData {
    private final long id_value;
    private final List<StickerData> stickers_value;
    private final boolean stickers_absent;
    private final String name;
    private final String description;
    private final long skuId_value;
    private final long coverStickerId_value;
    private final boolean coverStickerId_absent;
    private final long bannerAssetId_value;
    private final boolean bannerAssetId_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableStickerPackData(Id id, Possible<List<StickerData>> stickers, String name, String description, Id skuId, Possible<Id> coverStickerId, Possible<Id> bannerAssetId) {
        Id id$impl = id;
        Possible<List<StickerData>> stickers$impl = stickers;
        this.name = Objects.requireNonNull(name, "name");
        this.description = Objects.requireNonNull(description, "description");
        Id skuId$impl = skuId;
        Possible<Id> coverStickerId$impl = coverStickerId;
        Possible<Id> bannerAssetId$impl = bannerAssetId;
        this.id_value = id$impl.asLong();
        this.stickers_value = stickers$impl.toOptional().orElse(null);
        this.stickers_absent = stickers$impl.isAbsent();
        this.skuId_value = skuId$impl.asLong();
        this.coverStickerId_value = coverStickerId$impl.toOptional().map(Id::asLong).orElse(0L);
        this.coverStickerId_absent = coverStickerId$impl.isAbsent();
        this.bannerAssetId_value = bannerAssetId$impl.toOptional().map(Id::asLong).orElse(0L);
        this.bannerAssetId_absent = bannerAssetId$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableStickerPackData(ImmutableStickerPackData original, Id id, Possible<List<StickerData>> stickers, String name, String description, Id skuId, Possible<Id> coverStickerId, Possible<Id> bannerAssetId) {
        Id id$impl = id;
        Possible<List<StickerData>> stickers$impl = stickers;
        this.name = name;
        this.description = description;
        Id skuId$impl = skuId;
        Possible<Id> coverStickerId$impl = coverStickerId;
        Possible<Id> bannerAssetId$impl = bannerAssetId;
        this.id_value = id$impl.asLong();
        this.stickers_value = stickers$impl.toOptional().orElse(null);
        this.stickers_absent = stickers$impl.isAbsent();
        this.skuId_value = skuId$impl.asLong();
        this.coverStickerId_value = coverStickerId$impl.toOptional().map(Id::asLong).orElse(0L);
        this.coverStickerId_absent = coverStickerId$impl.isAbsent();
        this.bannerAssetId_value = bannerAssetId$impl.toOptional().map(Id::asLong).orElse(0L);
        this.bannerAssetId_absent = bannerAssetId$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="id")
    public Id id() {
        return Id.of(this.id_value);
    }

    @Override
    @JsonProperty(value="stickers")
    public Possible<List<StickerData>> stickers() {
        return this.stickers_absent ? Possible.absent() : Possible.of(this.stickers_value);
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="description")
    public String description() {
        return this.description;
    }

    @Override
    @JsonProperty(value="sku_id")
    public Id skuId() {
        return Id.of(this.skuId_value);
    }

    @Override
    @JsonProperty(value="cover_sticker_id")
    public Possible<Id> coverStickerId() {
        return this.coverStickerId_absent ? Possible.absent() : Possible.of(Id.of(this.coverStickerId_value));
    }

    @Override
    @JsonProperty(value="banner_asset_id")
    public Possible<Id> bannerAssetId() {
        return this.bannerAssetId_absent ? Possible.absent() : Possible.of(Id.of(this.bannerAssetId_value));
    }

    public ImmutableStickerPackData withId(long value) {
        Id newValue = Id.of(value);
        return new ImmutableStickerPackData(this, newValue, this.stickers(), this.name, this.description, this.skuId(), this.coverStickerId(), this.bannerAssetId());
    }

    public ImmutableStickerPackData withId(String value) {
        Id newValue = Id.of(value);
        return new ImmutableStickerPackData(this, newValue, this.stickers(), this.name, this.description, this.skuId(), this.coverStickerId(), this.bannerAssetId());
    }

    public ImmutableStickerPackData withStickers(Possible<List<StickerData>> possible) {
        Possible<List<StickerData>> newValue = Objects.requireNonNull(possible);
        return new ImmutableStickerPackData(this, this.id(), newValue, this.name, this.description, this.skuId(), this.coverStickerId(), this.bannerAssetId());
    }

    public ImmutableStickerPackData withStickers(Iterable<StickerData> elements) {
        Possible<List<StickerData>> newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new ImmutableStickerPackData(this, this.id(), newValue, this.name, this.description, this.skuId(), this.coverStickerId(), this.bannerAssetId());
    }

    @SafeVarargs
    public final ImmutableStickerPackData withStickers(StickerData ... elements) {
        Possible<List<StickerData>> newValue = Possible.of(Arrays.asList(elements));
        return new ImmutableStickerPackData(this, this.id(), newValue, this.name, this.description, this.skuId(), this.coverStickerId(), this.bannerAssetId());
    }

    public final ImmutableStickerPackData withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableStickerPackData(this, this.id(), this.stickers(), newValue, this.description, this.skuId(), this.coverStickerId(), this.bannerAssetId());
    }

    public final ImmutableStickerPackData withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return new ImmutableStickerPackData(this, this.id(), this.stickers(), this.name, newValue, this.skuId(), this.coverStickerId(), this.bannerAssetId());
    }

    public ImmutableStickerPackData withSkuId(long value) {
        Id newValue = Id.of(value);
        return new ImmutableStickerPackData(this, this.id(), this.stickers(), this.name, this.description, newValue, this.coverStickerId(), this.bannerAssetId());
    }

    public ImmutableStickerPackData withSkuId(String value) {
        Id newValue = Id.of(value);
        return new ImmutableStickerPackData(this, this.id(), this.stickers(), this.name, this.description, newValue, this.coverStickerId(), this.bannerAssetId());
    }

    public ImmutableStickerPackData withCoverStickerId(Possible<Id> value) {
        Possible<Id> newValue = Objects.requireNonNull(value);
        return new ImmutableStickerPackData(this, this.id(), this.stickers(), this.name, this.description, this.skuId(), newValue, this.bannerAssetId());
    }

    public ImmutableStickerPackData withCoverStickerId(long value) {
        Possible<Id> newValue = Possible.of(Id.of(value));
        return new ImmutableStickerPackData(this, this.id(), this.stickers(), this.name, this.description, this.skuId(), newValue, this.bannerAssetId());
    }

    public ImmutableStickerPackData withBannerAssetId(Possible<Id> value) {
        Possible<Id> newValue = Objects.requireNonNull(value);
        return new ImmutableStickerPackData(this, this.id(), this.stickers(), this.name, this.description, this.skuId(), this.coverStickerId(), newValue);
    }

    public ImmutableStickerPackData withBannerAssetId(long value) {
        Possible<Id> newValue = Possible.of(Id.of(value));
        return new ImmutableStickerPackData(this, this.id(), this.stickers(), this.name, this.description, this.skuId(), this.coverStickerId(), newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableStickerPackData && this.equalTo(0, (ImmutableStickerPackData)another);
    }

    private boolean equalTo(int synthetic, ImmutableStickerPackData another) {
        return Objects.equals(this.id_value, another.id_value) && Objects.equals(this.stickers_value, another.stickers_value) && this.name.equals(another.name) && this.description.equals(another.description) && Objects.equals(this.skuId_value, another.skuId_value) && this.coverStickerId().equals(another.coverStickerId()) && this.bannerAssetId().equals(another.bannerAssetId());
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.id_value);
        h2 += (h2 << 5) + Objects.hashCode(this.stickers_value);
        h2 += (h2 << 5) + this.name.hashCode();
        h2 += (h2 << 5) + this.description.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.skuId_value);
        h2 += (h2 << 5) + this.coverStickerId().hashCode();
        h2 += (h2 << 5) + this.bannerAssetId().hashCode();
        return h2;
    }

    public String toString() {
        return "StickerPackData{id=" + Objects.toString(this.id_value) + ", stickers=" + Objects.toString(this.stickers_value) + ", name=" + this.name + ", description=" + this.description + ", skuId=" + Objects.toString(this.skuId_value) + ", coverStickerId=" + this.coverStickerId().toString() + ", bannerAssetId=" + this.bannerAssetId().toString() + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableStickerPackData fromJson(Json json) {
        Builder builder = ImmutableStickerPackData.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.stickers != null) {
            builder.stickers(json.stickers);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.skuId != null) {
            builder.skuId(json.skuId);
        }
        if (json.coverStickerId != null) {
            builder.coverStickerId(json.coverStickerId);
        }
        if (json.bannerAssetId != null) {
            builder.bannerAssetId(json.bannerAssetId);
        }
        return builder.build();
    }

    public static ImmutableStickerPackData of(Id id, Possible<List<StickerData>> stickers, String name, String description, Id skuId, Possible<Id> coverStickerId, Possible<Id> bannerAssetId) {
        return new ImmutableStickerPackData(id, stickers, name, description, skuId, coverStickerId, bannerAssetId);
    }

    public static ImmutableStickerPackData copyOf(StickerPackData instance) {
        if (instance instanceof ImmutableStickerPackData) {
            return (ImmutableStickerPackData)instance;
        }
        return ImmutableStickerPackData.builder().from(instance).build();
    }

    public boolean isStickersPresent() {
        return !this.stickers_absent;
    }

    public List<StickerData> stickersOrElse(List<StickerData> defaultValue) {
        return !this.stickers_absent ? this.stickers_value : defaultValue;
    }

    public boolean isCoverStickerIdPresent() {
        return !this.coverStickerId_absent;
    }

    public long coverStickerIdOrElse(long defaultValue) {
        return !this.coverStickerId_absent ? this.coverStickerId_value : defaultValue;
    }

    public boolean isBannerAssetIdPresent() {
        return !this.bannerAssetId_absent;
    }

    public long bannerAssetIdOrElse(long defaultValue) {
        return !this.bannerAssetId_absent ? this.bannerAssetId_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StickerPackData", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_DESCRIPTION = 2L;
        private long initBits = 3L;
        private Id id_id = null;
        private List<StickerData> stickers_list = null;
        private Id skuId_id = null;
        private Possible<Id> coverStickerId_possible = Possible.absent();
        private Possible<Id> bannerAssetId_possible = Possible.absent();
        private String name;
        private String description;

        private Builder() {
        }

        public final Builder from(StickerPackData instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.stickers(instance.stickers());
            this.name(instance.name());
            this.description(instance.description());
            this.skuId(instance.skuId());
            this.coverStickerId(instance.coverStickerId());
            this.bannerAssetId(instance.bannerAssetId());
            return this;
        }

        public Builder id(String value) {
            this.id_id = Id.of(value);
            return this;
        }

        public Builder id(long value) {
            this.id_id = Id.of(value);
            return this;
        }

        @JsonProperty(value="id")
        public Builder id(Id value) {
            this.id_id = value;
            return this;
        }

        public Builder addSticker(StickerData element) {
            this.stickers_getOrCreate().add(element);
            return this;
        }

        public Builder addAllStickers(List<StickerData> elements) {
            this.stickers_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="stickers")
        public Builder stickers(Possible<List<StickerData>> elements) {
            this.stickers_list = null;
            elements.toOptional().ifPresent(e -> this.stickers_getOrCreate().addAll((Collection<StickerData>)e));
            return this;
        }

        public Builder stickers(List<StickerData> elements) {
            this.stickers_list = new ArrayList<StickerData>(elements);
            return this;
        }

        public Builder stickers(Iterable<StickerData> elements) {
            this.stickers_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="description")
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder skuId(String value) {
            this.skuId_id = Id.of(value);
            return this;
        }

        public Builder skuId(long value) {
            this.skuId_id = Id.of(value);
            return this;
        }

        @JsonProperty(value="sku_id")
        public Builder skuId(Id value) {
            this.skuId_id = value;
            return this;
        }

        public Builder coverStickerId(String value) {
            this.coverStickerId_possible = Possible.of(Id.of(value));
            return this;
        }

        public Builder coverStickerId(long value) {
            this.coverStickerId_possible = Possible.of(Id.of(value));
            return this;
        }

        public Builder coverStickerId(Id value) {
            this.coverStickerId_possible = Possible.of(value);
            return this;
        }

        @JsonProperty(value="cover_sticker_id")
        public Builder coverStickerId(Possible<Id> value) {
            this.coverStickerId_possible = value;
            return this;
        }

        public Builder bannerAssetId(String value) {
            this.bannerAssetId_possible = Possible.of(Id.of(value));
            return this;
        }

        public Builder bannerAssetId(long value) {
            this.bannerAssetId_possible = Possible.of(Id.of(value));
            return this;
        }

        public Builder bannerAssetId(Id value) {
            this.bannerAssetId_possible = Possible.of(value);
            return this;
        }

        @JsonProperty(value="banner_asset_id")
        public Builder bannerAssetId(Possible<Id> value) {
            this.bannerAssetId_possible = value;
            return this;
        }

        public ImmutableStickerPackData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableStickerPackData(null, this.id_build(), this.stickers_build(), this.name, this.description, this.skuId_build(), this.coverStickerId_build(), this.bannerAssetId_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("description");
            }
            return "Cannot build StickerPackData, some of required attributes are not set " + attributes;
        }

        private Id id_build() {
            return this.id_id;
        }

        private Possible<List<StickerData>> stickers_build() {
            return this.stickers_list == null ? Possible.absent() : Possible.of(this.stickers_list);
        }

        private List<StickerData> stickers_getOrCreate() {
            if (this.stickers_list == null) {
                this.stickers_list = new ArrayList<StickerData>();
            }
            return this.stickers_list;
        }

        private Id skuId_build() {
            return this.skuId_id;
        }

        private Possible<Id> coverStickerId_build() {
            return this.coverStickerId_possible;
        }

        private Possible<Id> bannerAssetId_build() {
            return this.bannerAssetId_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="StickerPackData", generator="Immutables")
    static final class Json
    implements StickerPackData {
        Id id;
        Possible<List<StickerData>> stickers = Possible.absent();
        String name;
        String description;
        Id skuId;
        Possible<Id> coverStickerId = Possible.absent();
        Possible<Id> bannerAssetId = Possible.absent();

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(Id id) {
            this.id = id;
        }

        @JsonProperty(value="stickers")
        public void setStickers(Possible<List<StickerData>> stickers) {
            this.stickers = stickers;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="sku_id")
        public void setSkuId(Id skuId) {
            this.skuId = skuId;
        }

        @JsonProperty(value="cover_sticker_id")
        public void setCoverStickerId(Possible<Id> coverStickerId) {
            this.coverStickerId = coverStickerId;
        }

        @JsonProperty(value="banner_asset_id")
        public void setBannerAssetId(Possible<Id> bannerAssetId) {
            this.bannerAssetId = bannerAssetId;
        }

        @Override
        public Id id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<List<StickerData>> stickers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Id skuId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Id> coverStickerId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Id> bannerAssetId() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="StickerPackData", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build StickerPackData, attribute initializers form cycle " + attributes;
        }
    }
}

