/*
 * Decompiled with CFR 0.152.
 */
package discord4j.common.store.impl;

import discord4j.discordjson.Id;
import discord4j.discordjson.json.ImmutableGuildData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class WrappedGuildData {
    private final ImmutableGuildData guild;
    private final List<Id> members;
    private final List<Id> emojis;
    private final List<Id> stickers;
    private final List<Id> channels;
    private final List<Id> roles;

    WrappedGuildData(ImmutableGuildData guild) {
        this.guild = ImmutableGuildData.builder().from(guild).members(Collections.emptyList()).emojis(Collections.emptyList()).stickers(Collections.emptyList()).channels(Collections.emptyList()).roles(Collections.emptyList()).build();
        this.members = new ArrayList<Id>(guild.members());
        this.emojis = new ArrayList<Id>(guild.emojis());
        this.stickers = new ArrayList<Id>(guild.stickers().toOptional().orElse(Collections.emptyList()));
        this.channels = new ArrayList<Id>(guild.channels());
        this.roles = new ArrayList<Id>(guild.roles());
    }

    ImmutableGuildData unwrap() {
        return ImmutableGuildData.builder().from(this.guild).members(this.members).emojis(this.emojis).stickers(this.stickers).channels(this.channels).roles(this.roles).build();
    }

    List<Id> getMembers() {
        return this.members;
    }

    List<Id> getEmojis() {
        return this.emojis;
    }

    List<Id> getStickers() {
        return this.stickers;
    }

    List<Id> getChannels() {
        return this.channels;
    }

    List<Id> getRoles() {
        return this.roles;
    }
}

