/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.http;

import discord4j.rest.http.ReaderStrategy;
import discord4j.rest.json.response.ErrorResponse;
import io.netty.buffer.ByteBuf;
import io.netty.util.IllegalReferenceCountException;
import java.nio.charset.StandardCharsets;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class FallbackReaderStrategy
implements ReaderStrategy<Object> {
    @Override
    public boolean canRead(@Nullable Class<?> type, @Nullable String contentType) {
        return true;
    }

    @Override
    public Mono<Object> read(Mono<ByteBuf> content, Class<Object> responseType) {
        if (ErrorResponse.class.isAssignableFrom(responseType)) {
            return content.handle((buf, sink) -> {
                try {
                    ErrorResponse response = new ErrorResponse();
                    response.getFields().put("body", this.asString((ByteBuf)buf));
                    sink.next(response);
                }
                catch (IllegalReferenceCountException e) {
                    sink.complete();
                }
            });
        }
        return content.handle((buf, sink) -> {
            try {
                sink.next(this.asString((ByteBuf)buf));
            }
            catch (IllegalReferenceCountException e) {
                sink.complete();
            }
        });
    }

    private String asString(ByteBuf buf) {
        return buf.readCharSequence(buf.readableBytes(), StandardCharsets.UTF_8).toString();
    }
}

