/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.request;

import discord4j.common.sinks.EmissionStrategy;
import discord4j.rest.request.ProcessorRequestQueueFactory;
import discord4j.rest.request.RequestQueue;
import discord4j.rest.request.SinksRequestQueueFactory;
import java.time.Duration;
import java.util.function.Function;
import java.util.function.Supplier;
import reactor.core.publisher.FluxProcessor;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Sinks;
import reactor.util.concurrent.Queues;

public interface RequestQueueFactory {
    public <T> RequestQueue<T> create();

    @Deprecated
    public static RequestQueueFactory backedByProcessor(Supplier<FluxProcessor<Object, Object>> processorSupplier, FluxSink.OverflowStrategy overflowStrategy) {
        return new ProcessorRequestQueueFactory(processorSupplier, overflowStrategy);
    }

    public static RequestQueueFactory createFromSink(Function<Sinks.ManySpec, Sinks.Many<Object>> requestSinkFactory, EmissionStrategy emissionStrategy) {
        return new SinksRequestQueueFactory(requestSinkFactory, emissionStrategy);
    }

    public static RequestQueueFactory buffering() {
        return RequestQueueFactory.createFromSink(spec -> spec.multicast().onBackpressureBuffer(Queues.SMALL_BUFFER_SIZE, false), EmissionStrategy.park(Duration.ofMillis(10L)));
    }
}

