/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.domain.message;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.message.MessageEvent;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.channel.TextChannel;
import discord4j.gateway.ShardInfo;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public class MessageBulkDeleteEvent
extends MessageEvent {
    private final List<Long> messageIds;
    private final long channelId;
    private final long guildId;
    private final Set<Message> messages;

    public MessageBulkDeleteEvent(GatewayDiscordClient gateway, ShardInfo shardInfo, List<Long> messageIds, long channelId, long guildId, Set<Message> messages) {
        super(gateway, shardInfo);
        this.messageIds = messageIds;
        this.channelId = channelId;
        this.guildId = guildId;
        this.messages = messages;
    }

    public Set<Snowflake> getMessageIds() {
        return this.messageIds.stream().map(Snowflake::of).collect(Collectors.toSet());
    }

    public Set<Message> getMessages() {
        return this.messages;
    }

    public Snowflake getChannelId() {
        return Snowflake.of(this.channelId);
    }

    public Mono<TextChannel> getChannel() {
        return this.getClient().getChannelById(this.getChannelId()).cast(TextChannel.class);
    }

    public Snowflake getGuildId() {
        return Snowflake.of(this.guildId);
    }

    public Mono<Guild> getGuild() {
        return this.getClient().getGuildById(this.getGuildId());
    }

    public String toString() {
        return "MessageBulkDeleteEvent{messageIds=" + this.messageIds + ", channelId=" + this.channelId + ", guildId=" + this.guildId + ", messages=" + this.messages + '}';
    }
}

