/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.channel;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.time.Duration;
import reactor.netty.channel.AbstractChannelMetricsHandler;
import reactor.netty.channel.ChannelMetricsRecorder;
import reactor.util.annotation.Nullable;

public class ChannelMetricsHandler
extends AbstractChannelMetricsHandler {
    final ChannelMetricsRecorder recorder;

    ChannelMetricsHandler(ChannelMetricsRecorder recorder, @Nullable SocketAddress remoteAddress, boolean onServer) {
        super(remoteAddress, onServer);
        this.recorder = recorder;
    }

    @Override
    public ChannelHandler connectMetricsHandler() {
        return new ConnectMetricsHandler(this.recorder());
    }

    @Override
    public ChannelHandler tlsMetricsHandler() {
        return new TlsMetricsHandler(this.recorder);
    }

    @Override
    public ChannelMetricsRecorder recorder() {
        return this.recorder;
    }

    static class TlsMetricsHandler
    extends ChannelInboundHandlerAdapter {
        protected final ChannelMetricsRecorder recorder;

        TlsMetricsHandler(ChannelMetricsRecorder recorder) {
            this.recorder = recorder;
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) {
            long tlsHandshakeTimeStart = System.nanoTime();
            ctx.pipeline().get(SslHandler.class).handshakeFuture().addListener(f -> {
                ctx.pipeline().remove(this);
                this.recordTlsHandshakeTime(ctx, tlsHandshakeTimeStart, f.isSuccess() ? "SUCCESS" : "ERROR");
            });
            ctx.fireChannelActive();
        }

        protected void recordTlsHandshakeTime(ChannelHandlerContext ctx, long tlsHandshakeTimeStart, String status) {
            this.recorder.recordTlsHandshakeTime(ctx.channel().remoteAddress(), Duration.ofNanos(System.nanoTime() - tlsHandshakeTimeStart), status);
        }
    }

    static final class ConnectMetricsHandler
    extends ChannelOutboundHandlerAdapter {
        final ChannelMetricsRecorder recorder;

        ConnectMetricsHandler(ChannelMetricsRecorder recorder) {
            this.recorder = recorder;
        }

        @Override
        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            long connectTimeStart = System.nanoTime();
            super.connect(ctx, remoteAddress, localAddress, promise);
            promise.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                ctx.pipeline().remove(this);
                this.recorder.recordConnectTime(remoteAddress, Duration.ofNanos(System.nanoTime() - connectTimeStart), future.isSuccess() ? "SUCCESS" : "ERROR");
            }));
        }
    }
}

