/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.ffmpeg;

import com.github.kokorin.jaffree.process.Stopper;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FFmpegStopper
implements Stopper {
    private volatile Process process;
    private static final Logger LOGGER = LoggerFactory.getLogger(FFmpegStopper.class);

    @Override
    public void graceStop() {
        this.sendToStdIn("q");
    }

    @Override
    public void forceStop() {
        this.sendToStdIn("qq");
    }

    @Override
    public void setProcess(Process process) {
        this.process = process;
    }

    protected void sendToStdIn(String chars) {
        if (this.process == null) {
            LOGGER.error("No Process set yet, can't stop");
            return;
        }
        try (OutputStream stdIn = this.process.getOutputStream();){
            LOGGER.debug("Stopping ffmpeg by sending \"{}\" to StdIn", (Object)chars);
            stdIn.write(chars.getBytes());
            stdIn.flush();
        }
        catch (IOException e) {
            LOGGER.info("Ignoring {}: {}", (Object)e.getClass(), (Object)e.getMessage());
        }
    }
}

