/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver;

import com.gmail.berndivader.streamserver.config.Config;
import com.gmail.berndivader.streamserver.mysql.DatabaseConnection;
import com.gmail.berndivader.streamserver.term.ANSI;
import com.gmail.berndivader.streamserver.youtube.OAuth2;
import java.io.Console;
import java.util.Arrays;

public class InstallFlow {
    public boolean done = false;

    private InstallFlow() {
    }

    public static InstallFlow create() {
        return new InstallFlow();
    }

    public InstallFlow install() {
        try {
            String ask;
            ANSI.raw(Config.YAMPB_ANSI);
            ANSI.println("[WHITE]WELCOME TO THE YAMPB INSTALLING FLOW![RESET]");
            ANSI.println("[BLUE]=================================[BR]");
            if (InstallFlow.ask("Use MySql? [CYAN][YES/no]", "yes").equalsIgnoreCase("yes")) {
                while (!this.installDB() && !(ask = InstallFlow.ask("Failed to install database. Retry? [YES/no]", "yes")).equalsIgnoreCase("no")) {
                }
            } else {
                Config.MYSQL.USE = false;
            }
            if (InstallFlow.ask("[BR]Config YT broadcaster? [CYAN][YES/no]", "yes").equalsIgnoreCase("yes")) {
                while (!this.installBC() && !(ask = InstallFlow.ask("Failed to setup yt broadcaster. Retry? [YES/no]", "yes")).equalsIgnoreCase("no")) {
                }
            } else {
                Config.BROADCASTER.STREAM_BOT_START = false;
            }
            if (InstallFlow.ask("[BR]Config Discord bot? [CYAN][YES/no]", "yes").equalsIgnoreCase("yes")) {
                while (!this.installDC() && !(ask = InstallFlow.ask("Failed to setup Discord bot. Retry? [YES/no]", "yes")).equalsIgnoreCase("no")) {
                }
            } else {
                Config.DISCORD.BOT_START = false;
            }
            Config.saveConfig();
            this.done = true;
        }
        catch (Exception e) {
            ANSI.error("Failed to run throu installation flow.", e);
            this.done = false;
        }
        return this;
    }

    private boolean installDB() {
        boolean use = false;
        Config.MYSQL.HOST = InstallFlow.ask(String.format("MySQL hostname? [CYAN][%s]", Config.MYSQL.HOST), Config.MYSQL.HOST);
        Config.MYSQL.PORT = InstallFlow.ask(String.format("MySQL port? [CYAN][%s]", Config.MYSQL.PORT), Config.MYSQL.PORT);
        Config.MYSQL.NAME = InstallFlow.ask(String.format("MySQL databasename? [CYAN][%s]", Config.MYSQL.NAME), Config.MYSQL.NAME);
        Config.MYSQL.USER = InstallFlow.ask(String.format("MySQL username? [CYAN][%s]", Config.MYSQL.USER), Config.MYSQL.USER);
        Config.MYSQL.PWD = InstallFlow.askPwd("MySQL password? [CYAN][blank for current]", Config.MYSQL.PWD);
        DatabaseConnection.STATUS test = DatabaseConnection.testInstall();
        ANSI.info(test.msg());
        switch (test) {
            case OK: 
            case DB_CORRUPT_ERROR: 
            case DB_TABLE_NOTFOUND_ERROR: {
                use = DatabaseConnection.setup();
                break;
            }
            default: {
                use = false;
            }
        }
        Config.MYSQL.USE = use;
        return Config.MYSQL.USE;
    }

    private boolean installBC() {
        boolean use = true;
        Config.BROADCASTER.YOUTUBE_API_KEY = InstallFlow.ask(String.format("Youtube API key? [CYAN][%s]", Config.BROADCASTER.YOUTUBE_API_KEY), Config.BROADCASTER.YOUTUBE_API_KEY);
        Config.BROADCASTER.YOUTUBE_CLIENT_ID = InstallFlow.ask(String.format("OAuth2 client id? [CYAN][%s]", Config.BROADCASTER.YOUTUBE_CLIENT_ID), Config.BROADCASTER.YOUTUBE_CLIENT_ID);
        Config.BROADCASTER.YOUTUBE_CLIENT_SECRET = InstallFlow.ask(String.format("OAuth2 client secret? [CYAN][%s]", Config.BROADCASTER.YOUTUBE_CLIENT_SECRET), Config.BROADCASTER.YOUTUBE_CLIENT_SECRET);
        Config.BROADCASTER.YOUTUBE_AUTH_REDIRECT = InstallFlow.ask(String.format("OAuth2 redirect page? [CYAN][%s]", Config.BROADCASTER.YOUTUBE_AUTH_REDIRECT), Config.BROADCASTER.YOUTUBE_AUTH_REDIRECT);
        Config.BROADCASTER.YOUTUBE_STREAM_KEY = InstallFlow.ask(String.format("Livestream key? [CYAN][%s]", Config.BROADCASTER.YOUTUBE_STREAM_KEY), Config.BROADCASTER.YOUTUBE_STREAM_KEY);
        Config.BROADCASTER.YOUTUBE_STREAM_URL = InstallFlow.ask(String.format("Livestream rtmp url? [CYAN][%s]", Config.BROADCASTER.YOUTUBE_STREAM_URL), Config.BROADCASTER.YOUTUBE_STREAM_URL);
        Config.BROADCASTER.BROADCAST_DEFAULT_PRIVACY = InstallFlow.ask(String.format("Livestream default privacy?[BR]Possible values: PUBLIC|UNLISTED|PRIVATE [CYAN][%s]", Config.BROADCASTER.BROADCAST_DEFAULT_PRIVACY), Config.BROADCASTER.BROADCAST_DEFAULT_PRIVACY);
        Config.BROADCASTER.BROADCAST_DEFAULT_TITLE = InstallFlow.ask(String.format("Default Livestream Title? [CYAN][%s]", Config.BROADCASTER.BROADCAST_DEFAULT_TITLE), Config.BROADCASTER.BROADCAST_DEFAULT_TITLE);
        Config.BROADCASTER.BROADCAST_DEFAULT_DESCRIPTION = InstallFlow.ask(String.format("Default Livestream Title? [CYAN][%s]", Config.BROADCASTER.BROADCAST_DEFAULT_DESCRIPTION), Config.BROADCASTER.BROADCAST_DEFAULT_DESCRIPTION);
        if (InstallFlow.ask("Try to create OAuth2 Access Token?[CYAN][YES/no][BR][GREEN](Valid redirect page is required for this action.)", "yes").equalsIgnoreCase("yes")) {
            OAuth2.build();
        }
        Config.BROADCASTER.STREAM_BOT_START = use;
        return Config.BROADCASTER.STREAM_BOT_START;
    }

    private boolean installDC() {
        boolean use = true;
        ANSI.println("[BLUE]To get/create token for your bot visit: https://discord.com/developers/applications");
        Config.DISCORD.TOKEN = InstallFlow.ask(String.format("Discord bot token? [CYAN][%s]", Config.DISCORD.TOKEN), Config.DISCORD.TOKEN);
        Config.DISCORD.MUSIC_BOT = InstallFlow.ask("Use music bot? [CYAN][yes/NO]", "no").equalsIgnoreCase("yes");
        if (Config.DISCORD.MUSIC_BOT.booleanValue()) {
            Config.DISCORD.VOICE_CHANNEL_NAME = InstallFlow.ask(String.format("Voice channel by name? [CYAN][%s]", Config.DISCORD.VOICE_CHANNEL_NAME), Config.DISCORD.VOICE_CHANNEL_NAME);
            Config.DISCORD.MUSIC_AUTOPLAY = InstallFlow.ask("Use music bot? [CYAN][yes/NO]", "no").equalsIgnoreCase("yes");
        }
        if (InstallFlow.ask("Setup a default guild permission? [CYAN][YES/no]", "yes").equalsIgnoreCase("yes")) {
            // empty if block
        }
        Config.DISCORD.BOT_START = use;
        return Config.DISCORD.BOT_START;
    }

    private static String ask(String question, String preset) {
        ANSI.print(String.format("[YELLOW]%s [WHITE]", question));
        String answer = ANSI.keyboard.nextLine();
        if (answer.isEmpty() || answer.equals(preset)) {
            return preset;
        }
        return answer;
    }

    private static String askPwd(String question, String current) {
        Console console = System.console();
        if (console == null) {
            return current;
        }
        ANSI.print(String.format("[YELLOW]%s [WHITE]", question));
        char[] chars = console.readPassword();
        String pwd = new String(chars);
        Arrays.fill(chars, ' ');
        return pwd;
    }
}

