/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.console.command;

import com.gmail.berndivader.streamserver.YAMPB;
import com.gmail.berndivader.streamserver.annotation.ConsoleCommand;
import com.gmail.berndivader.streamserver.config.Config;
import com.gmail.berndivader.streamserver.console.command.Command;
import com.gmail.berndivader.streamserver.discord.DiscordBot;
import com.gmail.berndivader.streamserver.ffmpeg.BroadcastRunner;
import com.gmail.berndivader.streamserver.mysql.DatabaseConnection;
import com.gmail.berndivader.streamserver.term.ANSI;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class Commands {
    public static Commands instance;
    static final String PACKAGE_NAME = "com/gmail/berndivader/streamserver/console/command/commands";
    static String fileName;
    public HashMap<String, String> cmds = new HashMap();

    public Commands() {
        try {
            this.loadCommandClasses();
        }
        catch (IOException | ClassNotFoundException e) {
            ANSI.error("Failed to instantiate console commands.", e);
        }
    }

    void loadCommandClasses() throws IOException, ClassNotFoundException {
        try (JarInputStream jarStream = new JarInputStream(new FileInputStream(fileName));){
            while (jarStream.available() == 1) {
                Class<?> clazz;
                ConsoleCommand anno;
                String clazzName;
                JarEntry entry = jarStream.getNextJarEntry();
                if (entry == null || !(clazzName = entry.getName()).endsWith(".class") || !clazzName.startsWith(PACKAGE_NAME) || (anno = (clazz = Class.forName(clazzName = clazzName.substring(0, clazzName.length() - 6).replace("/", "."))).getAnnotation(ConsoleCommand.class)) == null) continue;
                boolean add = true;
                block14: for (int i = 0; i < anno.requireds().length; ++i) {
                    switch (anno.requireds()[i]) {
                        case BROADCASTRUNNER: {
                            add &= BroadcastRunner.instance != null;
                            continue block14;
                        }
                        case DISCORDBOT: {
                            add &= DiscordBot.instance != null;
                            continue block14;
                        }
                        case DATABASE: {
                            add &= DatabaseConnection.status == DatabaseConnection.STATUS.OK;
                            continue block14;
                        }
                        case DISCORDMUSIC: {
                            add &= Config.DISCORD.MUSIC_BOT.booleanValue();
                            continue block14;
                        }
                        case FFMPEG: {
                            add &= Config.FFMPEG_AVAIL;
                            continue block14;
                        }
                        case YTDLP: {
                            add &= Config.YTDLP_AVAIL;
                            continue block14;
                        }
                        default: {
                            add = true;
                        }
                    }
                }
                if (!add) continue;
                this.cmds.put(anno.name(), clazzName);
            }
        }
    }

    public Command getCommand(String name) {
        if (this.cmds.containsKey(name)) {
            String clazzName = this.cmds.get(name);
            try {
                Class<?> clazz = Class.forName(clazzName);
                if (clazz != null) {
                    return (Command)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                ANSI.error("Error getting console command class.", e);
            }
        }
        return null;
    }

    static {
        try {
            fileName = URLDecoder.decode(YAMPB.class.getProtectionDomain().getCodeSource().getLocation().getPath(), StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            try {
                fileName = URLDecoder.decode(YAMPB.class.getProtectionDomain().getCodeSource().getLocation().getPath(), StandardCharsets.ISO_8859_1.toString());
            }
            catch (UnsupportedEncodingException e1) {
                ANSI.error("Error, there is no UTF-8 nor a ISO-8859 encoding avaible.", e1);
            }
        }
    }
}

