/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.console.command.commands;

import com.gmail.berndivader.streamserver.annotation.ConsoleCommand;
import com.gmail.berndivader.streamserver.annotation.Requireds;
import com.gmail.berndivader.streamserver.console.command.Command;
import com.gmail.berndivader.streamserver.ffmpeg.BroadcastRunner;
import com.gmail.berndivader.streamserver.term.ANSI;
import java.util.concurrent.TimeUnit;

@ConsoleCommand(name="p", usage="[time|frames|bitrate|quality|fps|drops|size|speed] -> Show ffmpeg progress info.", requireds={Requireds.BROADCASTRUNNER})
public class ProgressInfo
extends Command {
    @Override
    public boolean execute(String[] args) {
        if (BroadcastRunner.isStreaming()) {
            if (BroadcastRunner.progress() != null) {
                ANSI.println("===Progress information===");
                long duration = BroadcastRunner.progress().getTime(TimeUnit.SECONDS);
                block23: for (int i1 = 0; i1 < args.length; ++i1) {
                    String option;
                    switch (option = args[i1]) {
                        case "time": {
                            ANSI.println("Playtime:" + duration / 60L + ":" + duration % 60L);
                            continue block23;
                        }
                        case "frames": 
                        case "frame": {
                            ANSI.println("Frames: " + BroadcastRunner.progress().getFrame());
                            continue block23;
                        }
                        case "bitrate": 
                        case "bits": {
                            ANSI.println("Bitrate: " + BroadcastRunner.progress().getBitrate());
                            continue block23;
                        }
                        case "quality": 
                        case "q": {
                            ANSI.println("Quality: " + BroadcastRunner.progress().getQ());
                            continue block23;
                        }
                        case "fps": {
                            ANSI.println("FPS: " + BroadcastRunner.progress().getFps());
                            continue block23;
                        }
                        case "drops": {
                            ANSI.println("Drops: " + BroadcastRunner.progress().getDrop());
                            continue block23;
                        }
                        case "size": {
                            ANSI.println("Size: " + BroadcastRunner.progress().getSize());
                            continue block23;
                        }
                        case "speed": {
                            ANSI.println("Speed: " + BroadcastRunner.progress().getSpeed());
                            continue block23;
                        }
                        default: {
                            ANSI.println("Playtime:" + duration / 60L + ":" + duration % 60L);
                            ANSI.println("Frames: " + BroadcastRunner.progress().getFrame());
                            ANSI.println("Bitrate: " + BroadcastRunner.progress().getBitrate());
                            ANSI.println("Quality: " + BroadcastRunner.progress().getQ());
                            ANSI.println("FPS: " + BroadcastRunner.progress().getFps());
                            ANSI.println("Drops: " + BroadcastRunner.progress().getDrop());
                            ANSI.println("Size: " + BroadcastRunner.progress().getSize());
                            ANSI.println("Speed: " + BroadcastRunner.progress().getSpeed());
                        }
                    }
                }
            } else {
                ANSI.println("No progress available atm.");
            }
        } else {
            ANSI.println("Currently no stream is running.");
        }
        return true;
    }
}

