/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.console.command.commands;

import com.gmail.berndivader.streamserver.Helper;
import com.gmail.berndivader.streamserver.annotation.ConsoleCommand;
import com.gmail.berndivader.streamserver.annotation.Requireds;
import com.gmail.berndivader.streamserver.console.command.Command;
import com.gmail.berndivader.streamserver.ffmpeg.BroadcastRunner;
import com.gmail.berndivader.streamserver.term.ANSI;

@ConsoleCommand(name="f", usage="[title|artist|date|comment|playtime|file|bitrate|format] -> Show ffmpegprobe gathered info.", requireds={Requireds.BROADCASTRUNNER})
public class StreamInfo
extends Command {
    @Override
    public boolean execute(String[] args) {
        if (BroadcastRunner.isStreaming()) {
            if (BroadcastRunner.playingPacket() != null) {
                ANSI.println("===Current playing===");
                block22: for (int i1 = 0; i1 < args.length; ++i1) {
                    switch (args[i1]) {
                        case "title": {
                            ANSI.println("Title: " + BroadcastRunner.playingPacket().tags.title);
                            continue block22;
                        }
                        case "artist": {
                            ANSI.println("Artist:" + BroadcastRunner.playingPacket().tags.artist);
                            continue block22;
                        }
                        case "date": {
                            ANSI.println("Date:" + BroadcastRunner.playingPacket().tags.date);
                            continue block22;
                        }
                        case "comment": {
                            ANSI.println("Comment:" + BroadcastRunner.playingPacket().tags.comment);
                            continue block22;
                        }
                        case "playtime": 
                        case "time": {
                            ANSI.println("Playtime:" + Helper.stringFloatToTime(BroadcastRunner.playingPacket().duration));
                            continue block22;
                        }
                        case "file": {
                            ANSI.println("File:" + BroadcastRunner.playingPacket().getPath());
                            continue block22;
                        }
                        case "bitrate": 
                        case "bits": {
                            ANSI.println("Bitrate:" + BroadcastRunner.playingPacket().bit_rate);
                            continue block22;
                        }
                        case "format": {
                            ANSI.println("Format:" + BroadcastRunner.playingPacket().format_long_name);
                            continue block22;
                        }
                        default: {
                            ANSI.println("Title: " + BroadcastRunner.playingPacket().tags.title);
                            ANSI.println("Artist:" + BroadcastRunner.playingPacket().tags.artist);
                            ANSI.println("Date:" + BroadcastRunner.playingPacket().tags.date);
                            ANSI.println("Comment:" + BroadcastRunner.playingPacket().tags.comment);
                            ANSI.println("Playtime:" + Helper.stringFloatToTime(BroadcastRunner.playingPacket().duration));
                            ANSI.println("File:" + BroadcastRunner.playingPacket().getPath());
                            ANSI.println("Bitrate:" + BroadcastRunner.playingPacket().bit_rate);
                            ANSI.println("Format:" + BroadcastRunner.playingPacket().format_name);
                        }
                    }
                }
            } else {
                ANSI.println("No information about stream available.");
            }
        } else {
            ANSI.println("Currently no stream is running.");
        }
        return true;
    }
}

