/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.ffmpeg;

import com.gmail.berndivader.streamserver.Helper;
import com.gmail.berndivader.streamserver.config.Config;
import com.gmail.berndivader.streamserver.term.ANSI;
import java.util.Map;

public class InfoPacket {
    private static final String UNKNOWN = "<UNKNOWN>";
    private static final String EMTPY = "";
    public String id = "<UNKNOWN>";
    public String title = "<UNKNOWN>";
    public String thumbnail = "";
    public String description = "<UNKNOWN>";
    public String channel_url = "";
    public String webpage_url = "";
    public String channel = "<UNKNOWN>";
    public String uploader = "<UNKNOWN>";
    public String uploader_url = "";
    public String upload_date = "";
    public String duration_string = "";
    public String format = "<UNKNOWN>";
    public String filename = "<UNKNOWN>";
    public String local_filename = "<UNKNOWN>";
    public Integer filesize_approx = -1;
    public Boolean downloadable = false;
    public Boolean temp = false;
    public String error = "<UNKNOWN>";

    private InfoPacket() {
    }

    public String toString() {
        return Helper.LGSON.toJson(this);
    }

    public boolean isSet(String field) {
        return field != null && !field.equals(UNKNOWN) && !field.equals(EMTPY);
    }

    public static InfoPacket empty() {
        return new InfoPacket();
    }

    public static InfoPacket build(String url) {
        InfoPacket packet = new InfoPacket();
        if (url == null || url.isEmpty()) {
            return packet;
        }
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command(Config.DOWNLOADER.YTDLP_PATH, "--quiet", "--no-warnings", "--dump-json", "--no-playlist");
        if (Config.DOWNLOADER.USE_COOKIES.booleanValue() && Config.cookiesExists()) {
            builder.command().add("--cookies");
            builder.command().add(Config.getCookies().getAbsolutePath());
        }
        builder.command().add(url);
        try {
            Map.Entry<String, String> output = Helper.startAndWaitForProcess(builder, 20L);
            String out = output.getKey();
            String err = output.getValue();
            if (!out.isEmpty()) {
                int index = out.indexOf(123);
                if (index != -1) {
                    out = out.substring(index);
                }
                packet = Helper.LGSON.fromJson(out, InfoPacket.class);
            }
            if (!err.isEmpty()) {
                ANSI.error(err, null);
                packet.error = err;
            }
        }
        catch (Exception e) {
            ANSI.error("Failed to build InfoPacket out of recieved Json string.", e);
        }
        if (!packet.isSet(packet.webpage_url)) {
            packet.webpage_url = url;
        }
        return packet;
    }
}

