/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.term;

import com.gmail.berndivader.streamserver.config.Config;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.time.Instant;
import java.util.Date;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public enum ANSI {
    STORE("\u001b[?47h"),
    RESTORE("\u001b[?47l"),
    CLR("\u001b[H\u001b[0J"),
    BR("\n"),
    CR("\r"),
    DL("\u001b[2K"),
    BELL("\u0007"),
    BOLD("\u001b[1m"),
    BOLDOFF("\u001b[22m"),
    BLINK("\u001b[5m"),
    BLINKOFF("\u001b[25m"),
    BLACK("\u001b[30m"),
    BLACKOFF("\u001b[39m"),
    RED("\u001b[31m"),
    REDOFF("\u001b[39m"),
    GREEN("\u001b[32m"),
    GREENOFF("\u001b[39m"),
    YELLOW("\u001b[33m"),
    YELLOWOFF("\u001b[39m"),
    BLUE("\u001b[34m"),
    BLUEOFF("\u001b[39m"),
    MAGENTA("\u001b[35m"),
    MAGENTAOFF("\u001b[39m"),
    CYAN("\u001b[36m"),
    CYANOFF("\u001b[39m"),
    WHITE("\u001b[37m"),
    WHITEOFF("\u001b[39m"),
    SYSTEM("\u001b[39m"),
    PROMPT("\u001b[0m\n>"),
    ERROR("\u001b[0m\u0007\u001b[1m\u001b[31m[ERROR]"),
    WARNING("\u001b[1m\u001b[33m[WARNING]"),
    RESET("\u001b[0m");

    public static Scanner keyboard;
    public static PrintStream console;
    private static Pattern pattern;
    private final String code;

    private ANSI(String code) {
        this.code = code;
    }

    public String toString() {
        return this.code;
    }

    public String str() {
        return this.code;
    }

    public static String parse(String string) {
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String token = matcher.group(1);
            if (token.charAt(0) == '/') {
                token = token.substring(1).concat("OFF");
            }
            try {
                if (!ANSI.contains(token)) continue;
                string = string.replace("[".concat(matcher.group(1).concat("]")), ANSI.valueOf(token).str());
            }
            catch (Exception exception) {}
        }
        return string;
    }

    private static boolean contains(String name) {
        String search = name.toUpperCase();
        return Stream.of(ANSI.values()).anyMatch(value -> value.name().equals(search));
    }

    public static String merge(ANSI ... ansis) {
        StringBuilder out = new StringBuilder();
        Stream.of(ansis).forEach(ansi -> out.append(ansi.str()));
        return out.toString();
    }

    public static void raw(String string) {
        console.print(ANSI.parse(string));
    }

    public static void info(String string) {
        if (!string.isBlank()) {
            console.printf("\u001b[36m[INFO]%s", ANSI.parse(string));
        } else {
            console.print(ANSI.parse(string));
        }
        console.print("\n");
        if (Config.DEBUG.booleanValue()) {
            ANSI.log(string, null);
        }
    }

    public static void warn(String string) {
        if (!string.isBlank()) {
            console.printf("%s%s", WARNING.str(), ANSI.parse(string));
        } else {
            console.print(ANSI.parse(string));
        }
        console.print("\n");
        if (Config.DEBUG.booleanValue()) {
            ANSI.log(string, null);
        }
    }

    public static void error(String string, Throwable error) {
        if (error == null) {
            error = new Throwable("Unknown");
        }
        console.printf("%s%s%s", ERROR.str(), ANSI.parse(string), BOLDOFF.str());
        if (Config.DEBUG.booleanValue()) {
            console.println();
            error.printStackTrace();
            ANSI.log(string, error);
        }
        console.print("\n");
    }

    public static void println(String string) {
        console.printf("%s%s%s", RESET.str(), ANSI.parse(string), BR.str());
    }

    public static void print(String string) {
        console.printf("%s%s", RESET.str(), ANSI.parse(string));
    }

    public static void prompt() {
        console.print(PROMPT.str());
    }

    private static void log(String string, Throwable throwable) {
        File file = new File(Config.config_dir, "debug.log");
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (file.exists()) {
            try (FileWriter writer = new FileWriter(file, true);){
                writer.append(String.valueOf(Date.from(Instant.now())) + ": " + string + "\n");
                if (throwable != null) {
                    writer.append(throwable.getMessage() + "\n");
                    throwable.printStackTrace(new PrintWriter(writer));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        pattern = Pattern.compile("\\[(.*?)\\]");
        keyboard = new Scanner(System.in);
        console = System.out;
    }
}

