/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.lava.common.natives.architecture;

import com.sedmelluq.lava.common.natives.architecture.OperatingSystemType;

public enum DefaultOperatingSystemTypes implements OperatingSystemType
{
    LINUX("linux", "lib", ".so"),
    WINDOWS("win", "", ".dll"),
    DARWIN("darwin", "lib", ".dylib"),
    SOLARIS("solaris", "lib", ".so");

    private final String identifier;
    private final String libraryFilePrefix;
    private final String libraryFileSuffix;

    private DefaultOperatingSystemTypes(String identifier, String libraryFilePrefix, String libraryFileSuffix) {
        this.identifier = identifier;
        this.libraryFilePrefix = libraryFilePrefix;
        this.libraryFileSuffix = libraryFileSuffix;
    }

    @Override
    public String identifier() {
        return this.identifier;
    }

    @Override
    public String libraryFilePrefix() {
        return this.libraryFilePrefix;
    }

    @Override
    public String libraryFileSuffix() {
        return this.libraryFileSuffix;
    }

    public static OperatingSystemType detect() {
        String osFullName = System.getProperty("os.name");
        if (osFullName.startsWith("Windows")) {
            return WINDOWS;
        }
        if (osFullName.startsWith("Mac OS X")) {
            return DARWIN;
        }
        if (osFullName.startsWith("Solaris")) {
            return SOLARIS;
        }
        if (osFullName.toLowerCase().startsWith("linux")) {
            return LINUX;
        }
        throw new IllegalArgumentException("Unknown operating system: " + osFullName);
    }
}

