/*
 * Decompiled with CFR 0.152.
 */
package discord4j.common.store.impl;

import discord4j.common.store.api.object.InvalidationCause;
import discord4j.common.store.impl.StorageBackend;
import java.util.EnumSet;
import reactor.util.annotation.Nullable;

public class StorageConfig {
    private final StorageBackend messageBackend;
    private final EnumSet<InvalidationCause> invalidationFilter;

    private StorageConfig(Builder b) {
        this.messageBackend = b.messageBackend == null ? StorageConfig.defaultMessageBackend() : b.messageBackend;
        this.invalidationFilter = b.invalidationFilter == null ? StorageConfig.defaultInvalidationFilter() : b.invalidationFilter;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static StorageBackend defaultMessageBackend() {
        return StorageBackend.caffeine(builder -> builder.maximumSize(1000L));
    }

    private static EnumSet<InvalidationCause> defaultInvalidationFilter() {
        return EnumSet.allOf(InvalidationCause.class);
    }

    public StorageBackend getMessageBackend() {
        return this.messageBackend;
    }

    public EnumSet<InvalidationCause> getInvalidationFilter() {
        return this.invalidationFilter;
    }

    public static class Builder {
        private StorageBackend messageBackend;
        private EnumSet<InvalidationCause> invalidationFilter;

        private Builder() {
        }

        public Builder setMessageBackend(@Nullable StorageBackend messageBackend) {
            this.messageBackend = messageBackend;
            return this;
        }

        public Builder setInvalidationFilter(@Nullable EnumSet<InvalidationCause> invalidationFilter) {
            this.invalidationFilter = invalidationFilter;
            return this;
        }

        public StorageConfig build() {
            return new StorageConfig(this);
        }
    }
}

