/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core;

import discord4j.core.CoreResources;
import discord4j.core.DiscordClientBuilder;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.shard.GatewayBootstrap;
import discord4j.gateway.GatewayOptions;
import discord4j.rest.RestClient;
import discord4j.rest.request.RouterOptions;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public final class DiscordClient
extends RestClient {
    private final CoreResources coreResources;

    DiscordClient(CoreResources coreResources) {
        super(coreResources);
        this.coreResources = coreResources;
    }

    public static DiscordClient create(String token) {
        return DiscordClientBuilder.create(token).build();
    }

    public static DiscordClientBuilder<DiscordClient, RouterOptions> builder(String token) {
        return DiscordClientBuilder.create(token);
    }

    public CoreResources getCoreResources() {
        return this.coreResources;
    }

    public Mono<GatewayDiscordClient> login() {
        return this.gateway().login();
    }

    public Mono<Void> withGateway(Function<GatewayDiscordClient, Publisher<?>> whileConnectedFunction) {
        return this.gateway().withGateway(whileConnectedFunction);
    }

    public GatewayBootstrap<GatewayOptions> gateway() {
        return GatewayBootstrap.create(this);
    }
}

