/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.domain;

import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.Event;
import discord4j.core.object.VoiceState;
import discord4j.gateway.ShardInfo;
import java.util.Optional;
import reactor.util.annotation.Nullable;

public class VoiceStateUpdateEvent
extends Event {
    private final VoiceState current;
    private final VoiceState old;

    public VoiceStateUpdateEvent(GatewayDiscordClient gateway, ShardInfo shardInfo, VoiceState current, @Nullable VoiceState old) {
        super(gateway, shardInfo);
        this.current = current;
        this.old = old;
    }

    public VoiceState getCurrent() {
        return this.current;
    }

    public Optional<VoiceState> getOld() {
        return Optional.ofNullable(this.old);
    }

    public boolean isJoinEvent() {
        return this.current.getChannelId().isPresent() && this.old == null;
    }

    public boolean isLeaveEvent() {
        return !this.current.getChannelId().isPresent() && this.old != null;
    }

    public boolean isMoveEvent() {
        if (this.old == null) {
            return false;
        }
        return this.current.getChannelId().flatMap(current -> this.old.getChannelId().map(current::equals)).orElse(true) == false;
    }

    public String toString() {
        return "VoiceStateUpdateEvent{current=" + this.current + ", old=" + this.old + '}';
    }
}

