/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.domain.guild;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.guild.GuildEvent;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.GuildEmoji;
import discord4j.gateway.ShardInfo;
import java.util.Optional;
import java.util.Set;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class EmojisUpdateEvent
extends GuildEvent {
    private final long guildId;
    private final Set<GuildEmoji> emojis;
    @Nullable
    private final Set<GuildEmoji> old;

    public EmojisUpdateEvent(GatewayDiscordClient gateway, ShardInfo shardInfo, long guildId, Set<GuildEmoji> emojis, Set<GuildEmoji> old) {
        super(gateway, shardInfo);
        this.guildId = guildId;
        this.emojis = emojis;
        this.old = old;
    }

    public Snowflake getGuildId() {
        return Snowflake.of(this.guildId);
    }

    public Mono<Guild> getGuild() {
        return this.getClient().getGuildById(this.getGuildId());
    }

    public Set<GuildEmoji> getEmojis() {
        return this.emojis;
    }

    public Optional<Set<GuildEmoji>> getOld() {
        return Optional.ofNullable(this.old);
    }

    public String toString() {
        return "EmojisUpdateEvent{guildId=" + this.guildId + ", emojis=" + this.emojis + ", old=" + this.old + '}';
    }
}

