/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.DiscordObject;
import discord4j.core.object.PermissionOverwrite;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.Role;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.GuildChannel;
import discord4j.core.retriever.EntityRetrievalStrategy;
import discord4j.discordjson.json.OverwriteData;
import java.util.Objects;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public final class ExtendedPermissionOverwrite
extends PermissionOverwrite
implements DiscordObject {
    private final GatewayDiscordClient gateway;
    private final long guildId;
    private final long channelId;

    public ExtendedPermissionOverwrite(GatewayDiscordClient gateway, OverwriteData data, long guildId, long channelId) {
        super(data.allow(), data.deny(), Snowflake.asLong(data.id()), PermissionOverwrite.Type.of(data.type()));
        this.gateway = Objects.requireNonNull(gateway);
        this.guildId = guildId;
        this.channelId = channelId;
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    public Mono<Role> getRole() {
        return Mono.justOrEmpty(this.getRoleId()).flatMap(id -> this.gateway.getRoleById(this.getGuildId(), (Snowflake)id));
    }

    public Mono<Role> getRole(EntityRetrievalStrategy retrievalStrategy) {
        return Mono.justOrEmpty(this.getRoleId()).flatMap(id -> this.gateway.withRetrievalStrategy(retrievalStrategy).getRoleById(this.getGuildId(), (Snowflake)id));
    }

    public Mono<User> getUser() {
        return Mono.justOrEmpty(this.getMemberId()).flatMap(this.gateway::getUserById);
    }

    public Mono<User> getUser(EntityRetrievalStrategy retrievalStrategy) {
        return Mono.justOrEmpty(this.getMemberId()).flatMap(id -> this.gateway.withRetrievalStrategy(retrievalStrategy).getUserById((Snowflake)id));
    }

    public Snowflake getGuildId() {
        return Snowflake.of(this.guildId);
    }

    public Mono<Guild> getGuild() {
        return this.gateway.getGuildById(this.getGuildId());
    }

    public Mono<Guild> getGuild(EntityRetrievalStrategy retrievalStrategy) {
        return this.gateway.withRetrievalStrategy(retrievalStrategy).getGuildById(this.getGuildId());
    }

    public Snowflake getChannelId() {
        return Snowflake.of(this.channelId);
    }

    public Mono<GuildChannel> getChannel() {
        return this.gateway.getChannelById(this.getChannelId()).cast(GuildChannel.class);
    }

    public Mono<GuildChannel> getChannel(EntityRetrievalStrategy retrievalStrategy) {
        return this.gateway.withRetrievalStrategy(retrievalStrategy).getChannelById(this.getChannelId()).cast(GuildChannel.class);
    }

    public Mono<Void> delete() {
        return this.delete(null);
    }

    public Mono<Void> delete(@Nullable String reason) {
        return this.gateway.getRestClient().getChannelService().deleteChannelPermission(this.channelId, this.getTargetId().asLong(), reason);
    }
}

