/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.command;

import discord4j.common.annotations.Experimental;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.DiscordObject;
import discord4j.core.object.command.ApplicationCommand;
import discord4j.core.object.command.ApplicationCommandInteractionOption;
import discord4j.core.object.command.ApplicationCommandInteractionResolved;
import discord4j.core.object.component.MessageComponent;
import discord4j.discordjson.json.ApplicationCommandInteractionData;
import discord4j.discordjson.json.ApplicationCommandInteractionOptionData;
import discord4j.discordjson.json.ApplicationCommandInteractionResolvedData;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import reactor.util.annotation.Nullable;

@Experimental
public class ApplicationCommandInteraction
implements DiscordObject {
    private final GatewayDiscordClient gateway;
    private final ApplicationCommandInteractionData data;
    @Nullable
    private final Long guildId;

    public ApplicationCommandInteraction(GatewayDiscordClient gateway, ApplicationCommandInteractionData data, @Nullable Long guildId) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
        this.guildId = guildId;
    }

    public Optional<Snowflake> getId() {
        return this.data.id().toOptional().map(Snowflake::of);
    }

    public Optional<String> getName() {
        return this.data.name().toOptional();
    }

    public Optional<ApplicationCommand.Type> getApplicationCommandType() {
        return this.data.type().toOptional().map(ApplicationCommand.Type::of);
    }

    public Optional<String> getCustomId() {
        return this.data.customId().toOptional();
    }

    public Optional<MessageComponent.Type> getComponentType() {
        return this.data.componentType().toOptional().map(MessageComponent.Type::of);
    }

    public List<ApplicationCommandInteractionOption> getOptions() {
        return this.data.options().toOptional().orElse(Collections.emptyList()).stream().map(data -> new ApplicationCommandInteractionOption(this.gateway, (ApplicationCommandInteractionOptionData)data, this.guildId, this.data.resolved().toOptional().orElse(null))).collect(Collectors.toList());
    }

    public Optional<ApplicationCommandInteractionOption> getOption(String name) {
        return this.data.options().toOptional().orElse(Collections.emptyList()).stream().filter(option -> option.name().equals(name)).findFirst().map(data -> new ApplicationCommandInteractionOption(this.gateway, (ApplicationCommandInteractionOptionData)data, this.guildId, this.data.resolved().toOptional().orElse(null)));
    }

    public Optional<List<String>> getValues() {
        return this.data.values().toOptional();
    }

    public Optional<ApplicationCommandInteractionResolved> getResolved() {
        return this.data.resolved().toOptional().map(data -> new ApplicationCommandInteractionResolved(this.gateway, (ApplicationCommandInteractionResolvedData)data, this.guildId));
    }

    public Optional<Snowflake> getTargetId() {
        return this.data.targetId().toOptional().map(Snowflake::of);
    }

    public List<MessageComponent> getComponents() {
        return this.data.components().toOptional().orElse(Collections.emptyList()).stream().map(MessageComponent::fromData).collect(Collectors.toList());
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    public String toString() {
        return "ApplicationCommandInteraction{data=" + this.data + ", guildId=" + this.guildId + '}';
    }
}

