/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.command;

import discord4j.common.annotations.Experimental;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.DiscordObject;
import discord4j.discordjson.json.ApplicationCommandOptionChoiceData;
import discord4j.discordjson.possible.Possible;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@Experimental
public class ApplicationCommandOptionChoice
implements DiscordObject {
    public static final int MAX_NAME_LENGTH = 100;
    public static final int MAX_VALUE_LENGTH = 100;
    private final GatewayDiscordClient gateway;
    private final ApplicationCommandOptionChoiceData data;

    public ApplicationCommandOptionChoice(GatewayDiscordClient gateway, ApplicationCommandOptionChoiceData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    public String getName() {
        return this.data.name();
    }

    public Map<Locale, String> getLocalizedNames() {
        return Possible.flatOpt(this.data.nameLocalizations()).orElse(Collections.emptyMap()).entrySet().stream().collect(Collectors.toMap(entry -> new Locale.Builder().setLanguageTag((String)entry.getKey()).build(), Map.Entry::getValue));
    }

    public Object getValue() {
        return this.data.value();
    }

    public String asString() {
        return String.valueOf(this.data.value());
    }

    public long asLong() {
        try {
            return Long.parseLong(this.asString());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Choice value cannot be converted to long", e);
        }
    }

    public double asDouble() {
        try {
            return Double.parseDouble(this.asString());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Choice value cannot be converted to double", e);
        }
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }
}

