/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.ApplicationTeamMember;
import discord4j.core.object.entity.Entity;
import discord4j.core.object.entity.User;
import discord4j.core.retriever.EntityRetrievalStrategy;
import discord4j.discordjson.json.ApplicationTeamData;
import discord4j.discordjson.json.ApplicationTeamMemberData;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public final class ApplicationTeam
implements Entity {
    private final GatewayDiscordClient gateway;
    private final ApplicationTeamData data;

    public ApplicationTeam(GatewayDiscordClient gateway, ApplicationTeamData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    @Override
    public Snowflake getId() {
        return Snowflake.of(this.data.id());
    }

    public List<ApplicationTeamMember> getMembers() {
        return this.data.members().stream().map(data -> new ApplicationTeamMember(this.gateway, (ApplicationTeamMemberData)data)).collect(Collectors.toList());
    }

    public String getName() {
        return this.data.name();
    }

    public Snowflake getOwnerId() {
        return Snowflake.of(this.data.ownerUserId().asLong());
    }

    public Mono<User> getOwner() {
        return this.gateway.getUserById(this.getOwnerId());
    }

    public Mono<User> getOwner(EntityRetrievalStrategy retrievalStrategy) {
        return this.gateway.withRetrievalStrategy(retrievalStrategy).getUserById(this.getOwnerId());
    }

    public String toString() {
        return "ApplicationTeam{data=" + this.data + '}';
    }
}

