/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity.channel;

import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.channel.BaseGuildChannel;
import discord4j.core.object.entity.channel.CategorizableChannel;
import discord4j.core.retriever.EntityRetrievalStrategy;
import discord4j.core.spec.CategoryEditMono;
import discord4j.core.spec.CategoryEditSpec;
import discord4j.core.spec.legacy.LegacyCategoryEditSpec;
import discord4j.core.util.EntityUtil;
import discord4j.discordjson.json.ChannelData;
import java.util.Objects;
import java.util.function.Consumer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class Category
extends BaseGuildChannel {
    public Category(GatewayDiscordClient gateway, ChannelData data) {
        super(gateway, data);
    }

    public Flux<CategorizableChannel> getChannels() {
        return this.getGuild().flatMapMany(Guild::getChannels).ofType(CategorizableChannel.class).filter(channel -> channel.getCategoryId().map(this.getId()::equals).orElse(false));
    }

    public Flux<CategorizableChannel> getChannels(EntityRetrievalStrategy retrievalStrategy) {
        return this.getGuild(retrievalStrategy).flatMapMany(guild -> guild.getChannels(retrievalStrategy)).ofType(CategorizableChannel.class).filter(channel -> channel.getCategoryId().map(this.getId()::equals).orElse(false));
    }

    @Deprecated
    public Mono<Category> edit(Consumer<? super LegacyCategoryEditSpec> spec) {
        return Mono.defer(() -> {
            LegacyCategoryEditSpec mutatedSpec = new LegacyCategoryEditSpec();
            spec.accept(mutatedSpec);
            return this.getClient().getRestClient().getChannelService().modifyChannel(this.getId().asLong(), mutatedSpec.asRequest(), mutatedSpec.getReason());
        }).map(data -> EntityUtil.getChannel(this.getClient(), data)).cast(Category.class);
    }

    public CategoryEditMono edit() {
        return CategoryEditMono.of(this);
    }

    public Mono<Category> edit(CategoryEditSpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> this.getClient().getRestClient().getChannelService().modifyChannel(this.getId().asLong(), spec.asRequest(), spec.reason())).map(data -> EntityUtil.getChannel(this.getClient(), data)).cast(Category.class);
    }

    @Override
    public String toString() {
        return "Category{} " + super.toString();
    }
}

