/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity.channel;

import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.channel.Channel;
import discord4j.core.retriever.EntityRetrievalStrategy;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.MessageCreateMono;
import discord4j.core.spec.MessageCreateSpec;
import discord4j.core.spec.legacy.LegacyEmbedCreateSpec;
import discord4j.core.spec.legacy.LegacyMessageCreateSpec;
import java.time.Instant;
import java.util.Optional;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface MessageChannel
extends Channel {
    public Optional<Snowflake> getLastMessageId();

    public Mono<Message> getLastMessage();

    public Mono<Message> getLastMessage(EntityRetrievalStrategy var1);

    public Optional<Instant> getLastPinTimestamp();

    @Deprecated
    public Mono<Message> createMessage(Consumer<? super LegacyMessageCreateSpec> var1);

    public Mono<Message> createMessage(MessageCreateSpec var1);

    default public MessageCreateMono createMessage(String message) {
        return MessageCreateMono.of(this).withContent(message);
    }

    default public MessageCreateMono createMessage(EmbedCreateSpec ... embeds) {
        return MessageCreateMono.of(this).withEmbeds(embeds);
    }

    @Deprecated
    default public Mono<Message> createEmbed(Consumer<? super LegacyEmbedCreateSpec> spec) {
        return this.createMessage((? super LegacyMessageCreateSpec messageSpec) -> messageSpec.setEmbed(spec));
    }

    @Deprecated
    default public MessageCreateMono createEmbed(EmbedCreateSpec embed) {
        return MessageCreateMono.of(this).withEmbeds(embed);
    }

    public Mono<Void> type();

    public Flux<Long> typeUntil(Publisher<?> var1);

    public Flux<Message> getMessagesBefore(Snowflake var1);

    public Flux<Message> getMessagesAfter(Snowflake var1);

    public Mono<Message> getMessageById(Snowflake var1);

    public Mono<Message> getMessageById(Snowflake var1, EntityRetrievalStrategy var2);

    public Flux<Message> getPinnedMessages();
}

