/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.presence;

import discord4j.core.object.presence.Activity;
import discord4j.core.object.presence.Status;
import discord4j.discordjson.json.PresenceData;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class Presence {
    private final PresenceData data;

    public Presence(PresenceData data) {
        this.data = data;
    }

    public Status getStatus() {
        return Status.of(this.data.status());
    }

    public Optional<Status> getStatus(Status.Platform platform) {
        switch (platform) {
            case DESKTOP: {
                return this.data.clientStatus().desktop().toOptional().map(Status::of);
            }
            case MOBILE: {
                return this.data.clientStatus().mobile().toOptional().map(Status::of);
            }
            case WEB: {
                return this.data.clientStatus().web().toOptional().map(Status::of);
            }
        }
        throw new IllegalArgumentException("Unhandled platform " + (Object)((Object)platform));
    }

    public Optional<Activity> getActivity() {
        return this.data.activities().stream().map(Activity::new).findFirst();
    }

    public List<Activity> getActivities() {
        return this.data.activities().stream().map(Activity::new).collect(Collectors.toList());
    }

    public String toString() {
        return "Presence{data=" + this.data + '}';
    }
}

