/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.shard;

import discord4j.common.LogUtil;
import discord4j.common.ReactorResources;
import discord4j.common.annotations.Experimental;
import discord4j.common.retry.ReconnectOptions;
import discord4j.common.store.Store;
import discord4j.common.store.action.gateway.GatewayActions;
import discord4j.common.store.impl.LocalStoreLayout;
import discord4j.common.util.Snowflake;
import discord4j.core.DiscordClient;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.GatewayResources;
import discord4j.core.event.EventDispatcher;
import discord4j.core.event.dispatch.DispatchContext;
import discord4j.core.event.dispatch.DispatchEventMapper;
import discord4j.core.object.presence.ClientPresence;
import discord4j.core.retriever.EntityRetrievalStrategy;
import discord4j.core.shard.GatewayClientGroupManager;
import discord4j.core.shard.LocalShardCoordinator;
import discord4j.core.shard.MemberRequestFilter;
import discord4j.core.shard.ShardCoordinator;
import discord4j.core.shard.ShardingStrategy;
import discord4j.discordjson.json.gateway.GuildMembersChunk;
import discord4j.discordjson.json.gateway.StatusUpdate;
import discord4j.gateway.DefaultGatewayClient;
import discord4j.gateway.GatewayClient;
import discord4j.gateway.GatewayObserver;
import discord4j.gateway.GatewayOptions;
import discord4j.gateway.GatewayReactorResources;
import discord4j.gateway.IdentifyOptions;
import discord4j.gateway.SessionInfo;
import discord4j.gateway.ShardInfo;
import discord4j.gateway.intent.Intent;
import discord4j.gateway.intent.IntentSet;
import discord4j.gateway.limiter.PayloadTransformer;
import discord4j.gateway.limiter.RateLimitTransformer;
import discord4j.gateway.payload.JacksonPayloadReader;
import discord4j.gateway.payload.JacksonPayloadWriter;
import discord4j.gateway.payload.PayloadReader;
import discord4j.gateway.payload.PayloadWriter;
import discord4j.gateway.retry.GatewayStateChange;
import discord4j.gateway.state.DispatchStoreLayer;
import discord4j.rest.util.Multimap;
import discord4j.rest.util.RouteUtils;
import discord4j.voice.DefaultVoiceConnectionFactory;
import discord4j.voice.VoiceConnectionFactory;
import discord4j.voice.VoiceReactorResources;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import reactor.core.Disposable;
import reactor.core.Disposables;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.core.publisher.Sinks;
import reactor.function.TupleUtils;
import reactor.netty.resources.ConnectionProvider;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;
import reactor.util.retry.Retry;

public class GatewayBootstrap<O extends GatewayOptions> {
    private static final Logger log = Loggers.getLogger(GatewayBootstrap.class);
    private final DiscordClient client;
    private final Function<GatewayOptions, O> optionsModifier;
    private ShardingStrategy shardingStrategy = ShardingStrategy.recommended();
    private Boolean awaitConnections = null;
    private ShardCoordinator shardCoordinator = null;
    private EventDispatcher eventDispatcher = null;
    private Store store = null;
    private MemberRequestFilter memberRequestFilter = null;
    private Function<ShardInfo, ClientPresence> initialPresence = shard -> null;
    private Function<ShardInfo, SessionInfo> resumeOptions = shard -> null;
    private IntentSet intents = IntentSet.nonPrivileged();
    private Boolean guildSubscriptions = null;
    private Function<GatewayDiscordClient, Mono<Void>> destroyHandler = GatewayBootstrap.shutdownDestroyHandler();
    private PayloadReader payloadReader = null;
    private PayloadWriter payloadWriter = null;
    private ReconnectOptions reconnectOptions = null;
    private ReconnectOptions voiceReconnectOptions = null;
    private GatewayObserver gatewayObserver = GatewayObserver.NOOP_LISTENER;
    private Function<ReactorResources, GatewayReactorResources> gatewayReactorResources = null;
    private Function<ReactorResources, VoiceReactorResources> voiceReactorResources = null;
    private VoiceConnectionFactory voiceConnectionFactory = GatewayBootstrap.defaultVoiceConnectionFactory();
    private EntityRetrievalStrategy entityRetrievalStrategy = null;
    private DispatchEventMapper dispatchEventMapper = null;
    private int maxMissedHeartbeatAck = 1;
    private Function<EventDispatcher, Publisher<?>> dispatcherFunction;
    private static final Sinks.EmitFailureHandler OPTIMISTIC = (signalType, emitResult) -> {
        if (emitResult == Sinks.EmitResult.FAIL_NON_SERIALIZED) {
            LockSupport.parkNanos(10L);
            return true;
        }
        return false;
    };

    public static GatewayBootstrap<GatewayOptions> create(DiscordClient client) {
        return new GatewayBootstrap<GatewayOptions>(client, Function.identity());
    }

    GatewayBootstrap(DiscordClient client, Function<GatewayOptions, O> optionsModifier) {
        this.client = client;
        this.optionsModifier = optionsModifier;
    }

    GatewayBootstrap(GatewayBootstrap<?> source, Function<GatewayOptions, O> optionsModifier) {
        this.optionsModifier = optionsModifier;
        this.client = source.client;
        this.shardingStrategy = source.shardingStrategy;
        this.awaitConnections = source.awaitConnections;
        this.shardCoordinator = source.shardCoordinator;
        this.eventDispatcher = source.eventDispatcher;
        this.store = source.store;
        this.memberRequestFilter = source.memberRequestFilter;
        this.initialPresence = source.initialPresence;
        this.resumeOptions = source.resumeOptions;
        this.intents = source.intents;
        this.guildSubscriptions = source.guildSubscriptions;
        this.destroyHandler = source.destroyHandler;
        this.payloadReader = source.payloadReader;
        this.payloadWriter = source.payloadWriter;
        this.reconnectOptions = source.reconnectOptions;
        this.voiceReconnectOptions = source.voiceReconnectOptions;
        this.gatewayObserver = source.gatewayObserver;
        this.gatewayReactorResources = source.gatewayReactorResources;
        this.voiceReactorResources = source.voiceReactorResources;
        this.voiceConnectionFactory = source.voiceConnectionFactory;
        this.entityRetrievalStrategy = source.entityRetrievalStrategy;
        this.dispatchEventMapper = source.dispatchEventMapper;
        this.maxMissedHeartbeatAck = source.maxMissedHeartbeatAck;
        this.dispatcherFunction = source.dispatcherFunction;
    }

    public <O2 extends GatewayOptions> GatewayBootstrap<O2> setExtraOptions(Function<? super O, O2> optionsModifier) {
        return new GatewayBootstrap<O2>(this, this.optionsModifier.andThen(optionsModifier));
    }

    public GatewayBootstrap<O> setSharding(ShardingStrategy shardingStrategy) {
        this.shardingStrategy = shardingStrategy;
        return this;
    }

    public GatewayBootstrap<O> setAwaitConnections(boolean awaitConnections) {
        this.awaitConnections = awaitConnections;
        return this;
    }

    public GatewayBootstrap<O> setShardCoordinator(ShardCoordinator shardCoordinator) {
        this.shardCoordinator = Objects.requireNonNull(shardCoordinator);
        return this;
    }

    public GatewayBootstrap<O> setEventDispatcher(@Nullable EventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
        return this;
    }

    public GatewayBootstrap<O> setStore(@Nullable Store store) {
        this.store = store;
        return this;
    }

    public GatewayBootstrap<O> setMemberRequestFilter(MemberRequestFilter memberRequestFilter) {
        this.memberRequestFilter = memberRequestFilter;
        return this;
    }

    public GatewayBootstrap<O> setDestroyHandler(Function<GatewayDiscordClient, Mono<Void>> destroyHandler) {
        this.destroyHandler = Objects.requireNonNull(destroyHandler, "destroyHandler");
        return this;
    }

    public GatewayBootstrap<O> setInitialPresence(Function<ShardInfo, ClientPresence> initialPresence) {
        this.initialPresence = Objects.requireNonNull(initialPresence, "initialPresence");
        return this;
    }

    @Deprecated
    public GatewayBootstrap<O> setInitialStatus(Function<ShardInfo, ClientPresence> initialStatus) {
        this.initialPresence = Objects.requireNonNull(initialStatus, "initialStatus");
        return this;
    }

    public GatewayBootstrap<O> setResumeOptions(Function<ShardInfo, SessionInfo> resumeOptions) {
        this.resumeOptions = Objects.requireNonNull(resumeOptions, "resumeOptions");
        return this;
    }

    public GatewayBootstrap<O> setEnabledIntents(IntentSet intents) {
        this.intents = Objects.requireNonNull(intents);
        return this;
    }

    public GatewayBootstrap<O> setDisabledIntents(IntentSet intents) {
        this.intents = IntentSet.all().andNot(Objects.requireNonNull(intents));
        return this;
    }

    public GatewayBootstrap<O> setPayloadReader(@Nullable PayloadReader payloadReader) {
        this.payloadReader = payloadReader;
        return this;
    }

    public GatewayBootstrap<O> setPayloadWriter(@Nullable PayloadWriter payloadWriter) {
        this.payloadWriter = payloadWriter;
        return this;
    }

    public GatewayBootstrap<O> setReconnectOptions(ReconnectOptions reconnectOptions) {
        this.reconnectOptions = Objects.requireNonNull(reconnectOptions);
        return this;
    }

    public GatewayBootstrap<O> setVoiceReconnectOptions(ReconnectOptions voiceReconnectOptions) {
        this.voiceReconnectOptions = Objects.requireNonNull(voiceReconnectOptions);
        return this;
    }

    public GatewayBootstrap<O> setGatewayObserver(GatewayObserver gatewayObserver) {
        this.gatewayObserver = Objects.requireNonNull(gatewayObserver);
        return this;
    }

    public GatewayBootstrap<O> setGatewayReactorResources(Function<ReactorResources, GatewayReactorResources> gatewayReactorResources) {
        this.gatewayReactorResources = Objects.requireNonNull(gatewayReactorResources);
        return this;
    }

    public GatewayBootstrap<O> setVoiceReactorResources(Function<ReactorResources, VoiceReactorResources> voiceReactorResources) {
        this.voiceReactorResources = Objects.requireNonNull(voiceReactorResources);
        return this;
    }

    public GatewayBootstrap<O> setVoiceConnectionFactory(VoiceConnectionFactory voiceConnectionFactory) {
        this.voiceConnectionFactory = Objects.requireNonNull(voiceConnectionFactory);
        return this;
    }

    public GatewayBootstrap<O> setEntityRetrievalStrategy(@Nullable EntityRetrievalStrategy entityRetrievalStrategy) {
        this.entityRetrievalStrategy = entityRetrievalStrategy;
        return this;
    }

    public GatewayBootstrap<O> setDispatchEventMapper(DispatchEventMapper dispatchEventMapper) {
        this.dispatchEventMapper = Objects.requireNonNull(dispatchEventMapper);
        return this;
    }

    public GatewayBootstrap<O> setMaxMissedHeartbeatAck(int maxMissedHeartbeatAck) {
        this.maxMissedHeartbeatAck = Math.max(0, maxMissedHeartbeatAck);
        return this;
    }

    @Experimental
    public GatewayBootstrap<O> withEventDispatcher(Function<EventDispatcher, Publisher<?>> dispatcherFunction) {
        this.dispatcherFunction = Objects.requireNonNull(dispatcherFunction);
        return this;
    }

    public Mono<Void> withGateway(Function<GatewayDiscordClient, Publisher<?>> whileConnectedFunction) {
        return this.usingConnection(gateway -> Flux.from((Publisher)whileConnectedFunction.apply((GatewayDiscordClient)gateway)).then(gateway.onDisconnect()));
    }

    private <T> Mono<T> usingConnection(Function<GatewayDiscordClient, Mono<T>> onConnectedFunction) {
        return Mono.usingWhen(this.login(), onConnectedFunction, GatewayDiscordClient::logout);
    }

    public Mono<GatewayDiscordClient> login() {
        return this.login(DefaultGatewayClient::new);
    }

    public Mono<GatewayDiscordClient> login(Function<O, GatewayClient> clientFactory) {
        return Mono.fromCallable(() -> new GatewayBootstrap<O>(this, this.optionsModifier)).zipWhen(b -> b.shardingStrategy.getShardCount(b.client)).flatMap(TupleUtils.function((b, count) -> {
            Store store = b.initStore();
            EventDispatcher eventDispatcher = b.initEventDispatcher();
            GatewayReactorResources gatewayReactorResources = b.initGatewayReactorResources((int)count);
            ShardCoordinator shardCoordinator = b.initShardCoordinator(gatewayReactorResources);
            VoiceReactorResources voiceReactorResources = b.initVoiceReactorResources();
            GatewayResources resources = new GatewayResources(store, eventDispatcher, shardCoordinator, b.initMemberRequestFilter(b.intents), gatewayReactorResources, b.initVoiceReactorResources(), b.initReconnectOptions(voiceReactorResources), b.intents);
            Sinks.Empty onCloseSink = Sinks.empty();
            AtomicReference dispatcherFunctionError = new AtomicReference();
            EntityRetrievalStrategy entityRetrievalStrategy = b.initEntityRetrievalStrategy();
            DispatchEventMapper dispatchMapper = b.initDispatchEventMapper();
            ConcurrentHashMap.KeySetView completingChunkNonces = ConcurrentHashMap.newKeySet();
            GatewayClientGroupManager clientGroup = b.shardingStrategy.getGroupManager((int)count);
            GatewayDiscordClient gateway = new GatewayDiscordClient(b.client, resources, onCloseSink.asMono(), clientGroup, b.voiceConnectionFactory, entityRetrievalStrategy, completingChunkNonces);
            Mono destroySequence = Mono.deferContextual(ctx -> b.destroyHandler.apply(gateway).doFinally(s2 -> {
                log.info(LogUtil.format(ctx, "All shards disconnected"));
                Throwable t = (Throwable)dispatcherFunctionError.get();
                if (t != null) {
                    onCloseSink.emitError(t, OPTIMISTIC);
                } else {
                    onCloseSink.emitEmpty(OPTIMISTIC);
                }
            })).cache();
            Flux connections = b.shardingStrategy.getMaxConcurrency(b.client).flatMapMany(maxConcurrency -> b.shardingStrategy.getShards((int)count).groupBy(shard -> shard.getIndex() % maxConcurrency).flatMap(group -> group.concatMap(shard -> this.acquireConnection((GatewayBootstrap<O>)b, (ShardInfo)shard, clientFactory, gateway, shardCoordinator, store, eventDispatcher, clientGroup, onCloseSink, dispatchMapper, completingChunkNonces, destroySequence.contextWrite(this.buildContext(gateway, (ShardInfo)shard)), (int)maxConcurrency))));
            Supplier<Mono> withEventDispatcherFunction = () -> Flux.from(b.dispatcherFunction.apply(eventDispatcher)).then().subscribeOn(gatewayReactorResources.getBlockingTaskScheduler()).onErrorResume(t -> {
                log.warn("Error in specified withEventDispatcher function. Handle this error to avoid terminating this connection.", (Throwable)t);
                dispatcherFunctionError.set(t);
                return gateway.logout();
            });
            Function<MonoSink, Flux> onFirstConnection = sink -> connections.switchOnFirst((first, flux) -> {
                if (first.hasValue()) {
                    sink.success(gateway);
                } else if (first.hasError()) {
                    sink.error(Objects.requireNonNull(first.getThrowable()));
                }
                return flux;
            });
            if (b.awaitConnections == null ? count == 1 : b.awaitConnections != false) {
                if (b.dispatcherFunction != null) {
                    return Mono.create((MonoSink<T> sink) -> {
                        Disposable.Composite cleanup = Disposables.composite();
                        cleanup.add(((Mono)withEventDispatcherFunction.get()).subscribe(null, t -> log.warn("Error terminating Gateway connection", (Throwable)t)));
                        cleanup.add(connections.then(Mono.just(gateway)).subscribe(sink::success, sink::error));
                        sink.onCancel(cleanup);
                    });
                }
                return connections.then(Mono.just(gateway));
            }
            if (b.dispatcherFunction != null) {
                return Mono.create((MonoSink<T> sink) -> {
                    Disposable.Composite cleanup = Disposables.composite();
                    cleanup.add(((Mono)withEventDispatcherFunction.get()).subscribe(null, t -> log.warn("Error terminating Gateway connection", (Throwable)t)));
                    cleanup.add(((Flux)onFirstConnection.apply((MonoSink)sink)).subscribe(null, t -> log.warn("Error in connections function", (Throwable)t)));
                    sink.onCancel(cleanup);
                });
            }
            return Mono.create((MonoSink<T> sink) -> sink.onCancel(((Flux)onFirstConnection.apply((MonoSink)sink)).subscribe(null, t -> log.warn("Error in connections function", (Throwable)t))));
        }));
    }

    private Mono<ShardInfo> acquireConnection(GatewayBootstrap<O> b, ShardInfo shard, Function<O, GatewayClient> clientFactory, GatewayDiscordClient gateway, ShardCoordinator shardCoordinator, Store store, EventDispatcher eventDispatcher, GatewayClientGroupManager clientGroup, Sinks.Empty<Void> onCloseSink, DispatchEventMapper dispatchMapper, Set<String> completingChunkNonces, Mono<Void> destroySequence, int maxConcurrency) {
        return Mono.deferContextual(ctx -> Mono.create((MonoSink<T> sink) -> {
            StatusUpdate initial = Optional.ofNullable(b.initialPresence.apply(shard)).map(ClientPresence::getStatusUpdate).orElse(null);
            IdentifyOptions identify = IdentifyOptions.builder(shard).initialStatus(initial).intents(b.intents).resumeSession(b.resumeOptions.apply(shard)).build();
            PayloadTransformer limiter = shardCoordinator.getIdentifyLimiter(shard, maxConcurrency);
            GatewayReactorResources resources = gateway.getGatewayResources().getGatewayReactorResources();
            ReconnectOptions reconnectOptions = this.initReconnectOptions(resources);
            GatewayOptions options = new GatewayOptions(this.client.getCoreResources().getToken(), resources, this.initPayloadReader(), this.initPayloadWriter(), reconnectOptions, identify, this.gatewayObserver, limiter, this.maxMissedHeartbeatAck);
            GatewayClient gatewayClient = (GatewayClient)clientFactory.apply((GatewayOptions)this.optionsModifier.apply(options));
            clientGroup.add(shard.getIndex(), gatewayClient);
            DispatchStoreLayer dispatchStoreLayer = DispatchStoreLayer.create(store, shard);
            Disposable.Composite forCleanup = Disposables.composite();
            forCleanup.add(gatewayClient.dispatch().takeUntilOther(onCloseSink.asMono()).checkpoint("Read payload from gateway").flatMap(dispatchStoreLayer::store).checkpoint("Write gateway update to the store").flatMap(statefulDispatch -> {
                if (!(statefulDispatch.getDispatch() instanceof GuildMembersChunk)) {
                    return Mono.just(statefulDispatch);
                }
                GuildMembersChunk chunk = (GuildMembersChunk)statefulDispatch.getDispatch();
                return Mono.justOrEmpty(chunk.nonce().toOptional()).filter(nonce -> chunk.chunkIndex() + 1 == chunk.chunkCount() && completingChunkNonces.remove(nonce)).flatMap(nonce -> Mono.from(store.execute(GatewayActions.completeGuildMembers(Snowflake.asLong(chunk.guildId()))))).thenReturn(statefulDispatch).onErrorResume(t -> {
                    log.warn(LogUtil.format(ctx, "Error sending completeGuildMembers to the store"), (Throwable)t);
                    return Mono.just(statefulDispatch);
                });
            }).flatMap(statefulDispatch -> {
                DispatchContext context = DispatchContext.of(statefulDispatch, gateway);
                return dispatchMapper.handle(context).contextWrite(c -> c.put("discord4j.shard", context.getShardInfo().getIndex())).onErrorResume(error -> {
                    log.error(LogUtil.format(ctx, "Error dispatching event"), (Throwable)error);
                    return Mono.empty();
                });
            }).doOnNext(eventDispatcher::publish).subscribe(null, t -> log.error(LogUtil.format(ctx, "Event mapper terminated with an error"), (Throwable)t), () -> log.debug(LogUtil.format(ctx, "Event mapper completed"))));
            forCleanup.add(gatewayClient.dispatch().ofType(GatewayStateChange.class).takeUntilOther(onCloseSink.asMono()).flatMap(event -> {
                SessionInfo session = null;
                switch (event.getState()) {
                    case CONNECTED: 
                    case RETRY_SUCCEEDED: {
                        return shardCoordinator.publishConnected(shard).publishOn(gateway.getGatewayResources().getGatewayReactorResources().getBlockingTaskScheduler()).doFinally(__ -> sink.success(shard));
                    }
                    case DISCONNECTED_RESUME: {
                        session = SessionInfo.create(gatewayClient.getSessionId(), gatewayClient.getSequence());
                    }
                    case DISCONNECTED: {
                        return shardCoordinator.publishDisconnected(shard, session).then(Mono.fromRunnable(() -> clientGroup.remove(shard.getIndex()))).then(shardCoordinator.getConnectedCount().filter(count -> count == 0).flatMap(__ -> destroySequence)).onErrorResume(t -> {
                            log.warn(LogUtil.format(ctx, "Error while releasing resources"), (Throwable)t);
                            return Mono.empty();
                        });
                    }
                    case RETRY_FAILED: {
                        log.debug(LogUtil.format(ctx, "Invalidating stores for shard"));
                    }
                }
                return Mono.empty();
            }).contextWrite(this.buildContext(gateway, shard)).subscribe(null, t -> log.error(LogUtil.format(ctx, "Lifecycle listener terminated with an error"), (Throwable)t), () -> log.debug(LogUtil.format(ctx, "Lifecycle listener completed"))));
            forCleanup.add(b.client.getGatewayService().getGateway().doOnSubscribe(s2 -> log.debug(LogUtil.format(ctx, "Acquiring gateway endpoint"))).retryWhen(Retry.backoff(reconnectOptions.getMaxRetries(), reconnectOptions.getFirstBackoff()).maxBackoff(reconnectOptions.getMaxBackoffInterval())).flatMap(response -> gatewayClient.execute(RouteUtils.expandQuery(response.url(), this.getGatewayParameters()))).doOnError(sink::error).doFinally(__ -> {
                sink.success();
                onCloseSink.emitEmpty(OPTIMISTIC);
            }).contextWrite(this.buildContext(gateway, shard)).subscribe(null, t -> log.debug(LogUtil.format(ctx, "Gateway terminated with an error: {}"), t.toString()), () -> log.debug(LogUtil.format(ctx, "Gateway completed"))));
            sink.onCancel(forCleanup);
        })).contextWrite(this.buildContext(gateway, shard));
    }

    private Function<Context, Context> buildContext(GatewayDiscordClient gateway, ShardInfo shard) {
        return ctx -> ctx.put("discord4j.gateway", Integer.toHexString(gateway.hashCode())).put("discord4j.shard", shard.getIndex());
    }

    private PayloadReader initPayloadReader() {
        if (this.payloadReader != null) {
            return this.payloadReader;
        }
        return new JacksonPayloadReader(this.client.getCoreResources().getJacksonResources().getObjectMapper());
    }

    private PayloadWriter initPayloadWriter() {
        if (this.payloadWriter != null) {
            return this.payloadWriter;
        }
        return new JacksonPayloadWriter(this.client.getCoreResources().getJacksonResources().getObjectMapper());
    }

    private ReconnectOptions initReconnectOptions(GatewayReactorResources resources) {
        if (this.reconnectOptions != null) {
            return this.reconnectOptions;
        }
        return ReconnectOptions.builder().setBackoffScheduler(resources.getTimerTaskScheduler()).build();
    }

    private ReconnectOptions initReconnectOptions(VoiceReactorResources resources) {
        if (this.reconnectOptions != null) {
            return this.reconnectOptions;
        }
        return ReconnectOptions.builder().setBackoffScheduler(resources.getTimerTaskScheduler()).build();
    }

    private GatewayReactorResources initGatewayReactorResources(int count) {
        if (this.gatewayReactorResources == null) {
            int maxConnections = Math.max(ConnectionProvider.DEFAULT_POOL_MAX_CONNECTIONS, count);
            this.gatewayReactorResources = res -> GatewayReactorResources.builder(res).httpClient(ReactorResources.newHttpClient(ConnectionProvider.create("d4j-gateway", maxConnections))).build();
        }
        return this.gatewayReactorResources.apply(this.client.getCoreResources().getReactorResources());
    }

    private VoiceReactorResources initVoiceReactorResources() {
        if (this.voiceReactorResources == null) {
            this.voiceReactorResources = VoiceReactorResources::new;
        }
        return this.voiceReactorResources.apply(this.client.getCoreResources().getReactorResources());
    }

    private EventDispatcher initEventDispatcher() {
        if (this.eventDispatcher != null) {
            return this.eventDispatcher;
        }
        return EventDispatcher.buffering();
    }

    private ShardCoordinator initShardCoordinator(ReactorResources reactorResources) {
        if (this.shardCoordinator != null) {
            return this.shardCoordinator;
        }
        return LocalShardCoordinator.create(() -> new RateLimitTransformer(1, Duration.ofSeconds(6L), reactorResources.getTimerTaskScheduler()));
    }

    private EntityRetrievalStrategy initEntityRetrievalStrategy() {
        if (this.entityRetrievalStrategy != null) {
            return this.entityRetrievalStrategy;
        }
        return EntityRetrievalStrategy.STORE_FALLBACK_REST;
    }

    private DispatchEventMapper initDispatchEventMapper() {
        if (this.dispatchEventMapper != null) {
            return this.dispatchEventMapper;
        }
        return DispatchEventMapper.emitEvents();
    }

    private Store initStore() {
        if (this.store != null) {
            return this.store;
        }
        return Store.fromLayout(LocalStoreLayout.create());
    }

    private MemberRequestFilter initMemberRequestFilter(IntentSet intents) {
        if (this.memberRequestFilter != null) {
            return this.memberRequestFilter;
        }
        if (intents.contains((Object)Intent.GUILD_MEMBERS)) {
            return MemberRequestFilter.withLargeGuilds();
        }
        return MemberRequestFilter.none();
    }

    private Multimap<String, Object> getGatewayParameters() {
        Multimap<String, Object> parameters = new Multimap<String, Object>(3);
        parameters.add("compress", "zlib-stream");
        parameters.add("encoding", "json");
        parameters.add("v", 8);
        return parameters;
    }

    public static Function<GatewayDiscordClient, Mono<Void>> noopDestroyHandler() {
        return gateway -> Mono.empty();
    }

    public static Function<GatewayDiscordClient, Mono<Void>> shutdownDestroyHandler() {
        return gateway -> {
            gateway.getEventDispatcher().shutdown();
            return Mono.empty();
        };
    }

    public static VoiceConnectionFactory defaultVoiceConnectionFactory() {
        return new DefaultVoiceConnectionFactory();
    }
}

