/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.shard;

import discord4j.common.LogUtil;
import discord4j.core.shard.ShardCoordinator;
import discord4j.gateway.SessionInfo;
import discord4j.gateway.ShardInfo;
import discord4j.gateway.limiter.PayloadTransformer;
import discord4j.gateway.limiter.RateLimitTransformer;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;
import reactor.util.Logger;
import reactor.util.Loggers;

public class LocalShardCoordinator
implements ShardCoordinator {
    private static final Logger log = Loggers.getLogger(LocalShardCoordinator.class);
    public static final Supplier<PayloadTransformer> DEFAULT_IDENTIFY_LIMITER_FACTORY = () -> new RateLimitTransformer(1, Duration.ofSeconds(6L));
    private final Map<Integer, PayloadTransformer> limiters = new ConcurrentHashMap<Integer, PayloadTransformer>(1);
    private final Supplier<PayloadTransformer> identifyLimiterFactory;
    private final Set<Integer> shards = ConcurrentHashMap.newKeySet();

    private LocalShardCoordinator(Supplier<PayloadTransformer> identifyLimiterFactory) {
        this.identifyLimiterFactory = identifyLimiterFactory;
    }

    public static LocalShardCoordinator create() {
        return new LocalShardCoordinator(DEFAULT_IDENTIFY_LIMITER_FACTORY);
    }

    public static LocalShardCoordinator create(Supplier<PayloadTransformer> identifyLimiterFactory) {
        return new LocalShardCoordinator(identifyLimiterFactory);
    }

    @Override
    public Mono<Void> publishConnected(ShardInfo shardInfo) {
        return Mono.deferContextual(ctx -> {
            boolean isNew = this.shards.add(shardInfo.getIndex());
            if (isNew) {
                log.info(LogUtil.format(ctx, "Shard connected"));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<Void> publishDisconnected(ShardInfo shardInfo, SessionInfo sessionInfo) {
        return Mono.deferContextual(ctx -> {
            boolean wasRemoved = this.shards.remove(shardInfo.getIndex());
            if (wasRemoved) {
                log.info(LogUtil.format(ctx, "Shard disconnected"));
            }
            return Mono.empty();
        });
    }

    @Override
    public PayloadTransformer getIdentifyLimiter(ShardInfo shardInfo, int maxConcurrency) {
        return this.limiters.computeIfAbsent(shardInfo.getIndex() % maxConcurrency, k -> this.identifyLimiterFactory.get());
    }

    @Override
    public Mono<Integer> getConnectedCount() {
        return Mono.fromCallable(this.shards::size);
    }
}

