/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.automod.AutoModRule;
import discord4j.core.spec.AutoModRuleEditMonoGenerator;
import discord4j.discordjson.json.AutoModActionData;
import discord4j.discordjson.json.AutoModTriggerMetaData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="AutoModRuleEditMonoGenerator", generator="Immutables")
public final class AutoModRuleEditMono
extends AutoModRuleEditMonoGenerator {
    @Nullable
    private final String reason;
    private final String name;
    private final int eventType;
    private final AutoModTriggerMetaData triggerMetaData_value;
    private final boolean triggerMetaData_absent;
    private final List<AutoModActionData> actions;
    private final boolean enabled;
    private final List<Snowflake> exemptRoles;
    private final List<Snowflake> exemptChannels;
    private final AutoModRule autoModRule;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private AutoModRuleEditMono(String name, int eventType, boolean enabled, AutoModRule autoModRule) {
        this.name = Objects.requireNonNull(name, "name");
        this.eventType = eventType;
        this.enabled = enabled;
        this.autoModRule = Objects.requireNonNull(autoModRule, "autoModRule");
        this.reason = null;
        Possible triggerMetaData$impl = Possible.absent();
        this.triggerMetaData_value = triggerMetaData$impl.toOptional().orElse(null);
        this.triggerMetaData_absent = triggerMetaData$impl.isAbsent();
        this.actions = this.initShim.actions();
        this.exemptRoles = this.initShim.exemptRoles();
        this.exemptChannels = this.initShim.exemptChannels();
        this.initShim = null;
    }

    private AutoModRuleEditMono(@Nullable String reason, String name, int eventType, Possible<AutoModTriggerMetaData> triggerMetaData, List<AutoModActionData> actions, boolean enabled, List<Snowflake> exemptRoles, List<Snowflake> exemptChannels, AutoModRule autoModRule) {
        this.reason = reason;
        this.name = name;
        this.eventType = eventType;
        Possible<AutoModTriggerMetaData> triggerMetaData$impl = triggerMetaData;
        this.initShim.actions(actions);
        this.enabled = enabled;
        this.initShim.exemptRoles(exemptRoles);
        this.initShim.exemptChannels(exemptChannels);
        this.autoModRule = autoModRule;
        this.triggerMetaData_value = triggerMetaData$impl.toOptional().orElse(null);
        this.triggerMetaData_absent = triggerMetaData$impl.isAbsent();
        this.actions = this.initShim.actions();
        this.exemptRoles = this.initShim.exemptRoles();
        this.exemptChannels = this.initShim.exemptChannels();
        this.initShim = null;
    }

    @Override
    @Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int eventType() {
        return this.eventType;
    }

    @Override
    public Possible<AutoModTriggerMetaData> triggerMetaData() {
        return this.triggerMetaData_absent ? Possible.absent() : Possible.of(this.triggerMetaData_value);
    }

    @Override
    public List<AutoModActionData> actions() {
        InitShim shim = this.initShim;
        return shim != null ? shim.actions() : this.actions;
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public List<Snowflake> exemptRoles() {
        InitShim shim = this.initShim;
        return shim != null ? shim.exemptRoles() : this.exemptRoles;
    }

    @Override
    public List<Snowflake> exemptChannels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.exemptChannels() : this.exemptChannels;
    }

    @Override
    public AutoModRule autoModRule() {
        return this.autoModRule;
    }

    public final AutoModRuleEditMono withReason(@Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new AutoModRuleEditMono(value, this.name, this.eventType, this.triggerMetaData(), this.actions, this.enabled, this.exemptRoles, this.exemptChannels, this.autoModRule);
    }

    public final AutoModRuleEditMono withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new AutoModRuleEditMono(this.reason, newValue, this.eventType, this.triggerMetaData(), this.actions, this.enabled, this.exemptRoles, this.exemptChannels, this.autoModRule);
    }

    public final AutoModRuleEditMono withEventType(int value) {
        if (this.eventType == value) {
            return this;
        }
        return new AutoModRuleEditMono(this.reason, this.name, value, this.triggerMetaData(), this.actions, this.enabled, this.exemptRoles, this.exemptChannels, this.autoModRule);
    }

    public AutoModRuleEditMono withTriggerMetaData(Possible<AutoModTriggerMetaData> value) {
        Possible<AutoModTriggerMetaData> newValue = Objects.requireNonNull(value);
        return new AutoModRuleEditMono(this.reason, this.name, this.eventType, newValue, this.actions, this.enabled, this.exemptRoles, this.exemptChannels, this.autoModRule);
    }

    public AutoModRuleEditMono withTriggerMetaData(AutoModTriggerMetaData value) {
        Possible<AutoModTriggerMetaData> newValue = Possible.of(value);
        return new AutoModRuleEditMono(this.reason, this.name, this.eventType, newValue, this.actions, this.enabled, this.exemptRoles, this.exemptChannels, this.autoModRule);
    }

    public final AutoModRuleEditMono withActions(AutoModActionData ... elements) {
        List<AutoModActionData> newValue = AutoModRuleEditMono.createUnmodifiableList(false, AutoModRuleEditMono.createSafeList(Arrays.asList(elements), true, false));
        return new AutoModRuleEditMono(this.reason, this.name, this.eventType, this.triggerMetaData(), newValue, this.enabled, this.exemptRoles, this.exemptChannels, this.autoModRule);
    }

    public final AutoModRuleEditMono withActions(Iterable<? extends AutoModActionData> elements) {
        if (this.actions == elements) {
            return this;
        }
        List<AutoModActionData> newValue = AutoModRuleEditMono.createUnmodifiableList(false, AutoModRuleEditMono.createSafeList(elements, true, false));
        return new AutoModRuleEditMono(this.reason, this.name, this.eventType, this.triggerMetaData(), newValue, this.enabled, this.exemptRoles, this.exemptChannels, this.autoModRule);
    }

    public final AutoModRuleEditMono withEnabled(boolean value) {
        if (this.enabled == value) {
            return this;
        }
        return new AutoModRuleEditMono(this.reason, this.name, this.eventType, this.triggerMetaData(), this.actions, value, this.exemptRoles, this.exemptChannels, this.autoModRule);
    }

    public final AutoModRuleEditMono withExemptRoles(Snowflake ... elements) {
        List<Snowflake> newValue = AutoModRuleEditMono.createUnmodifiableList(false, AutoModRuleEditMono.createSafeList(Arrays.asList(elements), true, false));
        return new AutoModRuleEditMono(this.reason, this.name, this.eventType, this.triggerMetaData(), this.actions, this.enabled, newValue, this.exemptChannels, this.autoModRule);
    }

    public final AutoModRuleEditMono withExemptRoles(Iterable<? extends Snowflake> elements) {
        if (this.exemptRoles == elements) {
            return this;
        }
        List<Snowflake> newValue = AutoModRuleEditMono.createUnmodifiableList(false, AutoModRuleEditMono.createSafeList(elements, true, false));
        return new AutoModRuleEditMono(this.reason, this.name, this.eventType, this.triggerMetaData(), this.actions, this.enabled, newValue, this.exemptChannels, this.autoModRule);
    }

    public final AutoModRuleEditMono withExemptChannels(Snowflake ... elements) {
        List<Snowflake> newValue = AutoModRuleEditMono.createUnmodifiableList(false, AutoModRuleEditMono.createSafeList(Arrays.asList(elements), true, false));
        return new AutoModRuleEditMono(this.reason, this.name, this.eventType, this.triggerMetaData(), this.actions, this.enabled, this.exemptRoles, newValue, this.autoModRule);
    }

    public final AutoModRuleEditMono withExemptChannels(Iterable<? extends Snowflake> elements) {
        if (this.exemptChannels == elements) {
            return this;
        }
        List<Snowflake> newValue = AutoModRuleEditMono.createUnmodifiableList(false, AutoModRuleEditMono.createSafeList(elements, true, false));
        return new AutoModRuleEditMono(this.reason, this.name, this.eventType, this.triggerMetaData(), this.actions, this.enabled, this.exemptRoles, newValue, this.autoModRule);
    }

    public final AutoModRuleEditMono withAutoModRule(AutoModRule value) {
        if (this.autoModRule == value) {
            return this;
        }
        AutoModRule newValue = Objects.requireNonNull(value, "autoModRule");
        return new AutoModRuleEditMono(this.reason, this.name, this.eventType, this.triggerMetaData(), this.actions, this.enabled, this.exemptRoles, this.exemptChannels, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AutoModRuleEditMono && this.equalTo(0, (AutoModRuleEditMono)another);
    }

    private boolean equalTo(int synthetic, AutoModRuleEditMono another) {
        return Objects.equals(this.reason, another.reason) && this.name.equals(another.name) && this.eventType == another.eventType && this.triggerMetaData().equals(another.triggerMetaData()) && this.actions.equals(another.actions) && this.enabled == another.enabled && this.exemptRoles.equals(another.exemptRoles) && this.exemptChannels.equals(another.exemptChannels) && this.autoModRule.equals(another.autoModRule);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.reason);
        h2 += (h2 << 5) + this.name.hashCode();
        h2 += (h2 << 5) + this.eventType;
        h2 += (h2 << 5) + this.triggerMetaData().hashCode();
        h2 += (h2 << 5) + this.actions.hashCode();
        h2 += (h2 << 5) + Boolean.hashCode(this.enabled);
        h2 += (h2 << 5) + this.exemptRoles.hashCode();
        h2 += (h2 << 5) + this.exemptChannels.hashCode();
        h2 += (h2 << 5) + this.autoModRule.hashCode();
        return h2;
    }

    @Override
    public String toString() {
        return "AutoModRuleEditMono{reason=" + this.reason + ", name=" + this.name + ", eventType=" + this.eventType + ", triggerMetaData=" + this.triggerMetaData().toString() + ", actions=" + this.actions + ", enabled=" + this.enabled + ", exemptRoles=" + this.exemptRoles + ", exemptChannels=" + this.exemptChannels + ", autoModRule=" + this.autoModRule + "}";
    }

    public static AutoModRuleEditMono of(String name, int eventType, boolean enabled, AutoModRule autoModRule) {
        return new AutoModRuleEditMono(name, eventType, enabled, autoModRule);
    }

    static AutoModRuleEditMono copyOf(AutoModRuleEditMonoGenerator instance) {
        if (instance instanceof AutoModRuleEditMono) {
            return (AutoModRuleEditMono)instance;
        }
        return AutoModRuleEditMono.of(instance.name(), instance.eventType(), instance.enabled(), instance.autoModRule()).withReason(instance.reason()).withTriggerMetaData(instance.triggerMetaData()).withActions(instance.actions()).withExemptRoles(instance.exemptRoles()).withExemptChannels(instance.exemptChannels());
    }

    public boolean isTriggerMetaDataPresent() {
        return !this.triggerMetaData_absent;
    }

    public AutoModTriggerMetaData triggerMetaDataOrElse(AutoModTriggerMetaData defaultValue) {
        return !this.triggerMetaData_absent ? this.triggerMetaData_value : defaultValue;
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="AutoModRuleEditMonoGenerator", generator="Immutables")
    private final class InitShim {
        private byte actionsBuildStage = 0;
        private List<AutoModActionData> actions;
        private byte exemptRolesBuildStage = 0;
        private List<Snowflake> exemptRoles;
        private byte exemptChannelsBuildStage = 0;
        private List<Snowflake> exemptChannels;

        private InitShim() {
        }

        List<AutoModActionData> actions() {
            if (this.actionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.actionsBuildStage == 0) {
                this.actionsBuildStage = (byte)-1;
                this.actions = AutoModRuleEditMono.createUnmodifiableList(false, AutoModRuleEditMono.createSafeList(AutoModRuleEditMono.super.actions(), true, false));
                this.actionsBuildStage = 1;
            }
            return this.actions;
        }

        void actions(List<AutoModActionData> actions) {
            this.actions = actions;
            this.actionsBuildStage = 1;
        }

        List<Snowflake> exemptRoles() {
            if (this.exemptRolesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.exemptRolesBuildStage == 0) {
                this.exemptRolesBuildStage = (byte)-1;
                this.exemptRoles = AutoModRuleEditMono.createUnmodifiableList(false, AutoModRuleEditMono.createSafeList(AutoModRuleEditMono.super.exemptRoles(), true, false));
                this.exemptRolesBuildStage = 1;
            }
            return this.exemptRoles;
        }

        void exemptRoles(List<Snowflake> exemptRoles) {
            this.exemptRoles = exemptRoles;
            this.exemptRolesBuildStage = 1;
        }

        List<Snowflake> exemptChannels() {
            if (this.exemptChannelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.exemptChannelsBuildStage == 0) {
                this.exemptChannelsBuildStage = (byte)-1;
                this.exemptChannels = AutoModRuleEditMono.createUnmodifiableList(false, AutoModRuleEditMono.createSafeList(AutoModRuleEditMono.super.exemptChannels(), true, false));
                this.exemptChannelsBuildStage = 1;
            }
            return this.exemptChannels;
        }

        void exemptChannels(List<Snowflake> exemptChannels) {
            this.exemptChannels = exemptChannels;
            this.exemptChannelsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.actionsBuildStage == -1) {
                attributes.add("actions");
            }
            if (this.exemptRolesBuildStage == -1) {
                attributes.add("exemptRoles");
            }
            if (this.exemptChannelsBuildStage == -1) {
                attributes.add("exemptChannels");
            }
            return "Cannot build AutoModRuleEditMono, attribute initializers form cycle " + attributes;
        }
    }
}

