/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Multimap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import reactor.util.annotation.Nullable;

final class InternalSpecUtils {
    private InternalSpecUtils() {
        throw new AssertionError();
    }

    static <T> Possible<T> toPossible(@Nullable T value) {
        return value == null ? Possible.absent() : Possible.of(value);
    }

    @Nullable
    static <T, R> R mapNullable(@Nullable T value, Function<? super T, ? extends R> mapper) {
        return value != null ? (R)mapper.apply((T)value) : null;
    }

    static void putIfNotNull(Map<String, Object> map, String key, @Nullable Object value) {
        if (value != null) {
            map.put(key, value);
        }
    }

    static void setIfNotNull(Multimap<String, Object> map, String key, @Nullable Object value) {
        if (value != null) {
            map.set(key, value);
        }
    }

    static void addAllIfNotNull(Multimap<String, Object> map, String key, @Nullable List<Object> values) {
        if (values != null) {
            map.addAll(key, values);
        }
    }

    static <T, R> Possible<R> mapPossible(Possible<T> value, Function<? super T, ? extends R> mapper) {
        return value.isAbsent() ? Possible.absent() : Possible.of(mapper.apply(value.get()));
    }

    static <T, R> Possible<Optional<R>> mapPossibleOptional(Possible<Optional<T>> value, Function<? super T, ? extends R> mapper) {
        return value.isAbsent() ? Possible.absent() : Possible.of(value.get().map(mapper));
    }
}

