/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.ScheduledEvent;
import discord4j.core.spec.ScheduledEventCreateMonoGenerator;
import discord4j.core.spec.ScheduledEventEntityMetadataSpec;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Image;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="ScheduledEventCreateMonoGenerator", generator="Immutables")
public final class ScheduledEventCreateMono
extends ScheduledEventCreateMonoGenerator {
    @Nullable
    private final String reason;
    private final Snowflake channelId_value;
    private final boolean channelId_absent;
    private final ScheduledEventEntityMetadataSpec entityMetadata_value;
    private final boolean entityMetadata_absent;
    private final String name;
    private final ScheduledEvent.PrivacyLevel privacyLevel;
    private final Instant scheduledStartTime;
    private final Instant scheduledEndTime_value;
    private final boolean scheduledEndTime_absent;
    private final String description_value;
    private final boolean description_absent;
    private final ScheduledEvent.EntityType entityType;
    private final Image image_value;
    private final boolean image_absent;
    private final Guild guild;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ScheduledEventCreateMono(String name, ScheduledEvent.PrivacyLevel privacyLevel, Instant scheduledStartTime, ScheduledEvent.EntityType entityType, Guild guild) {
        this.name = Objects.requireNonNull(name, "name");
        this.privacyLevel = Objects.requireNonNull(privacyLevel, "privacyLevel");
        this.scheduledStartTime = Objects.requireNonNull(scheduledStartTime, "scheduledStartTime");
        this.entityType = Objects.requireNonNull(entityType, "entityType");
        this.guild = Objects.requireNonNull(guild, "guild");
        this.reason = null;
        Possible channelId$impl = Possible.absent();
        Possible entityMetadata$impl = Possible.absent();
        Possible scheduledEndTime$impl = Possible.absent();
        Possible description$impl = Possible.absent();
        Possible image$impl = Possible.absent();
        this.channelId_value = channelId$impl.toOptional().orElse(null);
        this.channelId_absent = channelId$impl.isAbsent();
        this.entityMetadata_value = entityMetadata$impl.toOptional().orElse(null);
        this.entityMetadata_absent = entityMetadata$impl.isAbsent();
        this.scheduledEndTime_value = scheduledEndTime$impl.toOptional().orElse(null);
        this.scheduledEndTime_absent = scheduledEndTime$impl.isAbsent();
        this.description_value = description$impl.toOptional().orElse(null);
        this.description_absent = description$impl.isAbsent();
        this.image_value = image$impl.toOptional().orElse(null);
        this.image_absent = image$impl.isAbsent();
        this.initShim = null;
    }

    private ScheduledEventCreateMono(@Nullable String reason, Possible<Snowflake> channelId, Possible<ScheduledEventEntityMetadataSpec> entityMetadata, String name, ScheduledEvent.PrivacyLevel privacyLevel, Instant scheduledStartTime, Possible<Instant> scheduledEndTime, Possible<String> description, ScheduledEvent.EntityType entityType, Possible<Image> image, Guild guild) {
        this.reason = reason;
        Possible<Snowflake> channelId$impl = channelId;
        Possible<ScheduledEventEntityMetadataSpec> entityMetadata$impl = entityMetadata;
        this.name = name;
        this.privacyLevel = privacyLevel;
        this.scheduledStartTime = scheduledStartTime;
        Possible<Instant> scheduledEndTime$impl = scheduledEndTime;
        Possible<String> description$impl = description;
        this.entityType = entityType;
        Possible<Image> image$impl = image;
        this.guild = guild;
        this.channelId_value = channelId$impl.toOptional().orElse(null);
        this.channelId_absent = channelId$impl.isAbsent();
        this.entityMetadata_value = entityMetadata$impl.toOptional().orElse(null);
        this.entityMetadata_absent = entityMetadata$impl.isAbsent();
        this.scheduledEndTime_value = scheduledEndTime$impl.toOptional().orElse(null);
        this.scheduledEndTime_absent = scheduledEndTime$impl.isAbsent();
        this.description_value = description$impl.toOptional().orElse(null);
        this.description_absent = description$impl.isAbsent();
        this.image_value = image$impl.toOptional().orElse(null);
        this.image_absent = image$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public Possible<Snowflake> channelId() {
        return this.channelId_absent ? Possible.absent() : Possible.of(this.channelId_value);
    }

    @Override
    public Possible<ScheduledEventEntityMetadataSpec> entityMetadata() {
        return this.entityMetadata_absent ? Possible.absent() : Possible.of(this.entityMetadata_value);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ScheduledEvent.PrivacyLevel privacyLevel() {
        return this.privacyLevel;
    }

    @Override
    public Instant scheduledStartTime() {
        return this.scheduledStartTime;
    }

    @Override
    public Possible<Instant> scheduledEndTime() {
        return this.scheduledEndTime_absent ? Possible.absent() : Possible.of(this.scheduledEndTime_value);
    }

    @Override
    public Possible<String> description() {
        return this.description_absent ? Possible.absent() : Possible.of(this.description_value);
    }

    @Override
    public ScheduledEvent.EntityType entityType() {
        return this.entityType;
    }

    @Override
    public Possible<Image> image() {
        return this.image_absent ? Possible.absent() : Possible.of(this.image_value);
    }

    @Override
    public Guild guild() {
        return this.guild;
    }

    public final ScheduledEventCreateMono withReason(@Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new ScheduledEventCreateMono(value, this.channelId(), this.entityMetadata(), this.name, this.privacyLevel, this.scheduledStartTime, this.scheduledEndTime(), this.description(), this.entityType, this.image(), this.guild);
    }

    public ScheduledEventCreateMono withChannelId(Possible<Snowflake> value) {
        Possible<Snowflake> newValue = Objects.requireNonNull(value);
        return new ScheduledEventCreateMono(this.reason, newValue, this.entityMetadata(), this.name, this.privacyLevel, this.scheduledStartTime, this.scheduledEndTime(), this.description(), this.entityType, this.image(), this.guild);
    }

    public ScheduledEventCreateMono withChannelId(Snowflake value) {
        Possible<Snowflake> newValue = Possible.of(value);
        return new ScheduledEventCreateMono(this.reason, newValue, this.entityMetadata(), this.name, this.privacyLevel, this.scheduledStartTime, this.scheduledEndTime(), this.description(), this.entityType, this.image(), this.guild);
    }

    public ScheduledEventCreateMono withEntityMetadata(Possible<ScheduledEventEntityMetadataSpec> value) {
        Possible<ScheduledEventEntityMetadataSpec> newValue = Objects.requireNonNull(value);
        return new ScheduledEventCreateMono(this.reason, this.channelId(), newValue, this.name, this.privacyLevel, this.scheduledStartTime, this.scheduledEndTime(), this.description(), this.entityType, this.image(), this.guild);
    }

    public ScheduledEventCreateMono withEntityMetadata(ScheduledEventEntityMetadataSpec value) {
        Possible<ScheduledEventEntityMetadataSpec> newValue = Possible.of(value);
        return new ScheduledEventCreateMono(this.reason, this.channelId(), newValue, this.name, this.privacyLevel, this.scheduledStartTime, this.scheduledEndTime(), this.description(), this.entityType, this.image(), this.guild);
    }

    public final ScheduledEventCreateMono withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ScheduledEventCreateMono(this.reason, this.channelId(), this.entityMetadata(), newValue, this.privacyLevel, this.scheduledStartTime, this.scheduledEndTime(), this.description(), this.entityType, this.image(), this.guild);
    }

    public final ScheduledEventCreateMono withPrivacyLevel(ScheduledEvent.PrivacyLevel value) {
        ScheduledEvent.PrivacyLevel newValue = Objects.requireNonNull(value, "privacyLevel");
        if (this.privacyLevel == newValue) {
            return this;
        }
        return new ScheduledEventCreateMono(this.reason, this.channelId(), this.entityMetadata(), this.name, newValue, this.scheduledStartTime, this.scheduledEndTime(), this.description(), this.entityType, this.image(), this.guild);
    }

    public final ScheduledEventCreateMono withScheduledStartTime(Instant value) {
        if (this.scheduledStartTime == value) {
            return this;
        }
        Instant newValue = Objects.requireNonNull(value, "scheduledStartTime");
        return new ScheduledEventCreateMono(this.reason, this.channelId(), this.entityMetadata(), this.name, this.privacyLevel, newValue, this.scheduledEndTime(), this.description(), this.entityType, this.image(), this.guild);
    }

    public ScheduledEventCreateMono withScheduledEndTime(Possible<Instant> value) {
        Possible<Instant> newValue = Objects.requireNonNull(value);
        return new ScheduledEventCreateMono(this.reason, this.channelId(), this.entityMetadata(), this.name, this.privacyLevel, this.scheduledStartTime, newValue, this.description(), this.entityType, this.image(), this.guild);
    }

    public ScheduledEventCreateMono withScheduledEndTime(Instant value) {
        Possible<Instant> newValue = Possible.of(value);
        return new ScheduledEventCreateMono(this.reason, this.channelId(), this.entityMetadata(), this.name, this.privacyLevel, this.scheduledStartTime, newValue, this.description(), this.entityType, this.image(), this.guild);
    }

    public ScheduledEventCreateMono withDescription(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new ScheduledEventCreateMono(this.reason, this.channelId(), this.entityMetadata(), this.name, this.privacyLevel, this.scheduledStartTime, this.scheduledEndTime(), newValue, this.entityType, this.image(), this.guild);
    }

    public ScheduledEventCreateMono withDescription(String value) {
        Possible<String> newValue = Possible.of(value);
        return new ScheduledEventCreateMono(this.reason, this.channelId(), this.entityMetadata(), this.name, this.privacyLevel, this.scheduledStartTime, this.scheduledEndTime(), newValue, this.entityType, this.image(), this.guild);
    }

    public final ScheduledEventCreateMono withEntityType(ScheduledEvent.EntityType value) {
        ScheduledEvent.EntityType newValue = Objects.requireNonNull(value, "entityType");
        if (this.entityType == newValue) {
            return this;
        }
        return new ScheduledEventCreateMono(this.reason, this.channelId(), this.entityMetadata(), this.name, this.privacyLevel, this.scheduledStartTime, this.scheduledEndTime(), this.description(), newValue, this.image(), this.guild);
    }

    public ScheduledEventCreateMono withImage(Possible<Image> value) {
        Possible<Image> newValue = Objects.requireNonNull(value);
        return new ScheduledEventCreateMono(this.reason, this.channelId(), this.entityMetadata(), this.name, this.privacyLevel, this.scheduledStartTime, this.scheduledEndTime(), this.description(), this.entityType, newValue, this.guild);
    }

    public ScheduledEventCreateMono withImage(Image value) {
        Possible<Image> newValue = Possible.of(value);
        return new ScheduledEventCreateMono(this.reason, this.channelId(), this.entityMetadata(), this.name, this.privacyLevel, this.scheduledStartTime, this.scheduledEndTime(), this.description(), this.entityType, newValue, this.guild);
    }

    public final ScheduledEventCreateMono withGuild(Guild value) {
        if (this.guild == value) {
            return this;
        }
        Guild newValue = Objects.requireNonNull(value, "guild");
        return new ScheduledEventCreateMono(this.reason, this.channelId(), this.entityMetadata(), this.name, this.privacyLevel, this.scheduledStartTime, this.scheduledEndTime(), this.description(), this.entityType, this.image(), newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ScheduledEventCreateMono && this.equalTo(0, (ScheduledEventCreateMono)another);
    }

    private boolean equalTo(int synthetic, ScheduledEventCreateMono another) {
        return Objects.equals(this.reason, another.reason) && this.channelId().equals(another.channelId()) && this.entityMetadata().equals(another.entityMetadata()) && this.name.equals(another.name) && this.privacyLevel.equals((Object)another.privacyLevel) && this.scheduledStartTime.equals(another.scheduledStartTime) && this.scheduledEndTime().equals(another.scheduledEndTime()) && this.description().equals(another.description()) && this.entityType.equals((Object)another.entityType) && this.image().equals(another.image()) && this.guild.equals(another.guild);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.reason);
        h2 += (h2 << 5) + this.channelId().hashCode();
        h2 += (h2 << 5) + this.entityMetadata().hashCode();
        h2 += (h2 << 5) + this.name.hashCode();
        h2 += (h2 << 5) + this.privacyLevel.hashCode();
        h2 += (h2 << 5) + this.scheduledStartTime.hashCode();
        h2 += (h2 << 5) + this.scheduledEndTime().hashCode();
        h2 += (h2 << 5) + this.description().hashCode();
        h2 += (h2 << 5) + this.entityType.hashCode();
        h2 += (h2 << 5) + this.image().hashCode();
        h2 += (h2 << 5) + this.guild.hashCode();
        return h2;
    }

    @Override
    public String toString() {
        return "ScheduledEventCreateMono{reason=" + this.reason + ", channelId=" + this.channelId().toString() + ", entityMetadata=" + this.entityMetadata().toString() + ", name=" + this.name + ", privacyLevel=" + (Object)((Object)this.privacyLevel) + ", scheduledStartTime=" + this.scheduledStartTime + ", scheduledEndTime=" + this.scheduledEndTime().toString() + ", description=" + this.description().toString() + ", entityType=" + (Object)((Object)this.entityType) + ", image=" + this.image().toString() + ", guild=" + this.guild + "}";
    }

    public static ScheduledEventCreateMono of(String name, ScheduledEvent.PrivacyLevel privacyLevel, Instant scheduledStartTime, ScheduledEvent.EntityType entityType, Guild guild) {
        return new ScheduledEventCreateMono(name, privacyLevel, scheduledStartTime, entityType, guild);
    }

    static ScheduledEventCreateMono copyOf(ScheduledEventCreateMonoGenerator instance) {
        if (instance instanceof ScheduledEventCreateMono) {
            return (ScheduledEventCreateMono)instance;
        }
        return ScheduledEventCreateMono.of(instance.name(), instance.privacyLevel(), instance.scheduledStartTime(), instance.entityType(), instance.guild()).withReason(instance.reason()).withChannelId(instance.channelId()).withEntityMetadata(instance.entityMetadata()).withScheduledEndTime(instance.scheduledEndTime()).withDescription(instance.description()).withImage(instance.image());
    }

    public boolean isChannelIdPresent() {
        return !this.channelId_absent;
    }

    public Snowflake channelIdOrElse(Snowflake defaultValue) {
        return !this.channelId_absent ? this.channelId_value : defaultValue;
    }

    public boolean isEntityMetadataPresent() {
        return !this.entityMetadata_absent;
    }

    public ScheduledEventEntityMetadataSpec entityMetadataOrElse(ScheduledEventEntityMetadataSpec defaultValue) {
        return !this.entityMetadata_absent ? this.entityMetadata_value : defaultValue;
    }

    public boolean isScheduledEndTimePresent() {
        return !this.scheduledEndTime_absent;
    }

    public Instant scheduledEndTimeOrElse(Instant defaultValue) {
        return !this.scheduledEndTime_absent ? this.scheduledEndTime_value : defaultValue;
    }

    public boolean isDescriptionPresent() {
        return !this.description_absent;
    }

    public String descriptionOrElse(String defaultValue) {
        return !this.description_absent ? this.description_value : defaultValue;
    }

    public boolean isImagePresent() {
        return !this.image_absent;
    }

    public Image imageOrElse(Image defaultValue) {
        return !this.image_absent ? this.image_value : defaultValue;
    }

    @Generated(from="ScheduledEventCreateMonoGenerator", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build ScheduledEventCreateMono, attribute initializers form cycle " + attributes;
        }
    }
}

