/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec.legacy;

import discord4j.core.object.PermissionOverwrite;
import discord4j.core.object.entity.channel.Channel;
import discord4j.core.spec.legacy.LegacyAuditSpec;
import discord4j.discordjson.json.ChannelCreateRequest;
import discord4j.discordjson.json.ImmutableChannelCreateRequest;
import discord4j.discordjson.json.OverwriteData;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import reactor.util.annotation.Nullable;

public class LegacyCategoryCreateSpec
implements LegacyAuditSpec<ChannelCreateRequest> {
    private final ImmutableChannelCreateRequest.Builder requestBuilder = ChannelCreateRequest.builder().type(Channel.Type.GUILD_CATEGORY.getValue());
    @Nullable
    private String reason;

    public LegacyCategoryCreateSpec setName(String name) {
        this.requestBuilder.name(name);
        return this;
    }

    public LegacyCategoryCreateSpec setPosition(int position) {
        this.requestBuilder.position(position);
        return this;
    }

    public LegacyCategoryCreateSpec setPermissionOverwrites(Set<? extends PermissionOverwrite> permissionOverwrites) {
        List<OverwriteData> raw = permissionOverwrites.stream().map(PermissionOverwrite::getData).collect(Collectors.toList());
        this.requestBuilder.permissionOverwrites(raw);
        return this;
    }

    public LegacyCategoryCreateSpec setReason(@Nullable String reason) {
        this.reason = reason;
        return this;
    }

    @Override
    @Nullable
    public String getReason() {
        return this.reason;
    }

    @Override
    public ChannelCreateRequest asRequest() {
        return this.requestBuilder.build();
    }
}

