/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec.legacy;

import discord4j.core.spec.legacy.LegacySpec;
import discord4j.discordjson.json.EmbedAuthorData;
import discord4j.discordjson.json.EmbedData;
import discord4j.discordjson.json.EmbedFieldData;
import discord4j.discordjson.json.EmbedFooterData;
import discord4j.discordjson.json.EmbedImageData;
import discord4j.discordjson.json.EmbedThumbnailData;
import discord4j.discordjson.json.ImmutableEmbedData;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Color;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import reactor.util.annotation.Nullable;

public class LegacyEmbedCreateSpec
implements LegacySpec<EmbedData> {
    private final ImmutableEmbedData.Builder requestBuilder = EmbedData.builder();
    private final List<EmbedFieldData> fields = new ArrayList<EmbedFieldData>();

    public LegacyEmbedCreateSpec setTitle(String title) {
        this.requestBuilder.title(title);
        return this;
    }

    public LegacyEmbedCreateSpec setDescription(String description) {
        this.requestBuilder.description(description);
        return this;
    }

    public LegacyEmbedCreateSpec setUrl(String url) {
        this.requestBuilder.url(url);
        return this;
    }

    public LegacyEmbedCreateSpec setTimestamp(Instant timestamp) {
        this.requestBuilder.timestamp(DateTimeFormatter.ISO_INSTANT.format(timestamp));
        return this;
    }

    public LegacyEmbedCreateSpec setColor(Color color) {
        this.requestBuilder.color(color.getRGB());
        return this;
    }

    public LegacyEmbedCreateSpec setFooter(String text, @Nullable String iconUrl) {
        this.requestBuilder.footer(EmbedFooterData.builder().text(text).iconUrl(iconUrl == null ? Possible.absent() : Possible.of(iconUrl)).build());
        return this;
    }

    public LegacyEmbedCreateSpec setImage(String url) {
        this.requestBuilder.image(EmbedImageData.builder().url(url).build());
        return this;
    }

    public LegacyEmbedCreateSpec setThumbnail(String url) {
        this.requestBuilder.thumbnail(EmbedThumbnailData.builder().url(url).build());
        return this;
    }

    public LegacyEmbedCreateSpec setAuthor(String name, @Nullable String url, @Nullable String iconUrl) {
        this.requestBuilder.author(EmbedAuthorData.builder().name(name).url(url == null ? Possible.absent() : Possible.of(Optional.of(url))).iconUrl(iconUrl == null ? Possible.absent() : Possible.of(iconUrl)).build());
        return this;
    }

    public LegacyEmbedCreateSpec addField(String name, String value, boolean inline) {
        this.fields.add(EmbedFieldData.builder().name(name).value(value).inline(inline).build());
        return this;
    }

    public LegacyEmbedCreateSpec from(EmbedData embedData) {
        this.requestBuilder.from(embedData);
        this.fields.clear();
        this.fields.addAll(embedData.fields().toOptional().orElseGet(ArrayList::new));
        return this;
    }

    @Override
    public EmbedData asRequest() {
        this.requestBuilder.fields(this.fields);
        return this.requestBuilder.build();
    }
}

