/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec.legacy;

import discord4j.common.util.Snowflake;
import discord4j.core.object.Region;
import discord4j.core.object.entity.Guild;
import discord4j.core.spec.legacy.LegacyAuditSpec;
import discord4j.discordjson.json.GuildModifyRequest;
import discord4j.discordjson.json.ImmutableGuildModifyRequest;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Image;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import reactor.util.annotation.Nullable;

public class LegacyGuildEditSpec
implements LegacyAuditSpec<GuildModifyRequest> {
    private final ImmutableGuildModifyRequest.Builder requestBuilder = GuildModifyRequest.builder();
    @Nullable
    private String reason;

    public LegacyGuildEditSpec setName(String name) {
        this.requestBuilder.name(name);
        return this;
    }

    public LegacyGuildEditSpec setRegion(Region.Id regionId) {
        this.requestBuilder.region(Possible.of(Optional.of(regionId).map(Region.Id::getValue)));
        return this;
    }

    public LegacyGuildEditSpec setRegion(@Nullable String regionId) {
        this.requestBuilder.region(Possible.of(Optional.ofNullable(regionId)));
        return this;
    }

    public LegacyGuildEditSpec setVerificationLevel(Guild.VerificationLevel verificationLevel) {
        this.requestBuilder.verificationLevelOrNull(verificationLevel.getValue());
        return this;
    }

    public LegacyGuildEditSpec setDefaultMessageNotificationsLevel(Guild.NotificationLevel notificationsLevel) {
        this.requestBuilder.defaultMessageNotificationsOrNull(notificationsLevel.getValue());
        return this;
    }

    public LegacyGuildEditSpec setExplicitContentFilter(Guild.ContentFilterLevel level) {
        this.requestBuilder.explicitContentFilterOrNull(level.getValue());
        return this;
    }

    public LegacyGuildEditSpec setAfkChannelId(@Nullable Snowflake afkChannelId) {
        this.requestBuilder.afkChannelId(Possible.of(Optional.ofNullable(afkChannelId).map(Snowflake::asString)));
        return this;
    }

    public LegacyGuildEditSpec setAfkTimeout(int afkTimeout) {
        this.requestBuilder.afkTimeout(afkTimeout);
        return this;
    }

    public LegacyGuildEditSpec setIcon(@Nullable Image icon) {
        this.requestBuilder.icon(Possible.of(Optional.ofNullable(icon).map(Image::getDataUri)));
        return this;
    }

    public LegacyGuildEditSpec setOwnerId(Snowflake ownerId) {
        this.requestBuilder.ownerId(ownerId.asString());
        return this;
    }

    public LegacyGuildEditSpec setSplash(@Nullable Image splash) {
        this.requestBuilder.splash(Possible.of(Optional.ofNullable(splash).map(Image::getDataUri)));
        return this;
    }

    public LegacyGuildEditSpec setDiscoverySplash(@Nullable Image discoverySplash) {
        this.requestBuilder.splash(Possible.of(Optional.ofNullable(discoverySplash).map(Image::getDataUri)));
        return this;
    }

    public LegacyGuildEditSpec setBanner(@Nullable Image banner) {
        this.requestBuilder.banner(Possible.of(Optional.ofNullable(banner).map(Image::getDataUri)));
        return this;
    }

    public LegacyGuildEditSpec setSystemChannelId(@Nullable Snowflake systemChannelId) {
        this.requestBuilder.systemChannelId(Possible.of(Optional.ofNullable(systemChannelId).map(Snowflake::asString)));
        return this;
    }

    @Deprecated
    public LegacyGuildEditSpec setSystemChannelFlags(@Nullable Guild.SystemChannelFlag flag) {
        this.requestBuilder.systemChannelFlags(flag == null ? Possible.absent() : Possible.of(flag.getValue()));
        return this;
    }

    public LegacyGuildEditSpec setSystemChannelFlags(Guild.SystemChannelFlag ... flags) {
        if (flags != null) {
            this.requestBuilder.systemChannelFlags(Possible.of(Arrays.stream(flags).mapToInt(Guild.SystemChannelFlag::getValue).reduce(0, (left, right) -> left | right)));
        } else {
            this.requestBuilder.systemChannelFlags(Possible.absent());
        }
        return this;
    }

    public LegacyGuildEditSpec setRulesChannelId(@Nullable Snowflake rulesChannelId) {
        this.requestBuilder.rulesChannelId(Possible.of(Optional.ofNullable(rulesChannelId).map(Snowflake::asString)));
        return this;
    }

    public LegacyGuildEditSpec setPublicUpdatesChannelId(@Nullable Snowflake publicUpdatesChannelId) {
        this.requestBuilder.publicUpdatesChannelId(Possible.of(Optional.ofNullable(publicUpdatesChannelId).map(Snowflake::asString)));
        return this;
    }

    public LegacyGuildEditSpec setPreferredLocale(@Nullable Locale preferredLocale) {
        this.requestBuilder.preferredLocale(Possible.of(Optional.ofNullable(preferredLocale).map(Locale::toLanguageTag)));
        return this;
    }

    public LegacyGuildEditSpec setFeatures(Set<String> features) {
        this.requestBuilder.features(features);
        return this;
    }

    public LegacyGuildEditSpec setDescription(@Nullable String description) {
        this.requestBuilder.descriptionOrNull(description);
        return this;
    }

    public LegacyGuildEditSpec setReason(@Nullable String reason) {
        this.reason = reason;
        return this;
    }

    @Override
    @Nullable
    public String getReason() {
        return this.reason;
    }

    @Override
    public GuildModifyRequest asRequest() {
        return this.requestBuilder.build();
    }
}

