/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec.legacy;

import discord4j.common.util.Snowflake;
import discord4j.core.object.PermissionOverwrite;
import discord4j.core.object.entity.channel.Channel;
import discord4j.core.spec.legacy.LegacyAuditSpec;
import discord4j.discordjson.json.ChannelCreateRequest;
import discord4j.discordjson.json.ImmutableChannelCreateRequest;
import discord4j.discordjson.json.OverwriteData;
import discord4j.discordjson.possible.Possible;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import reactor.util.annotation.Nullable;

public class LegacyTextChannelCreateSpec
implements LegacyAuditSpec<ChannelCreateRequest> {
    private final ImmutableChannelCreateRequest.Builder requestBuilder = ChannelCreateRequest.builder().type(Channel.Type.GUILD_TEXT.getValue());
    @Nullable
    private String reason;

    public LegacyTextChannelCreateSpec setName(String name) {
        this.requestBuilder.name(name);
        return this;
    }

    public LegacyTextChannelCreateSpec setTopic(@Nullable String topic) {
        this.requestBuilder.topic(topic == null ? Possible.absent() : Possible.of(topic));
        return this;
    }

    public LegacyTextChannelCreateSpec setRateLimitPerUser(int rateLimitPerUser) {
        this.requestBuilder.rateLimitPerUser(rateLimitPerUser);
        return this;
    }

    public LegacyTextChannelCreateSpec setPosition(int position) {
        this.requestBuilder.position(position);
        return this;
    }

    public LegacyTextChannelCreateSpec setPermissionOverwrites(Set<? extends PermissionOverwrite> permissionOverwrites) {
        List<OverwriteData> raw = permissionOverwrites.stream().map(PermissionOverwrite::getData).collect(Collectors.toList());
        this.requestBuilder.permissionOverwrites(raw);
        return this;
    }

    public LegacyTextChannelCreateSpec setParentId(@Nullable Snowflake parentId) {
        this.requestBuilder.parentId(parentId == null ? Possible.absent() : Possible.of(parentId.asString()));
        return this;
    }

    public LegacyTextChannelCreateSpec setNsfw(boolean nsfw) {
        this.requestBuilder.nsfw(nsfw);
        return this;
    }

    public LegacyTextChannelCreateSpec setReason(@Nullable String reason) {
        this.reason = reason;
        return this;
    }

    @Override
    @Nullable
    public String getReason() {
        return this.reason;
    }

    @Override
    public ChannelCreateRequest asRequest() {
        return this.requestBuilder.build();
    }
}

