/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.util;

import discord4j.core.object.PermissionOverwrite;
import discord4j.rest.util.Permission;
import discord4j.rest.util.PermissionSet;
import java.util.ArrayList;
import java.util.List;
import reactor.util.annotation.Nullable;

public final class PermissionUtil {
    public static PermissionSet computeBasePermissions(PermissionSet everyonePerms, List<PermissionSet> rolePerms) {
        return rolePerms.stream().reduce(everyonePerms, PermissionSet::or);
    }

    public static PermissionSet computePermissions(PermissionSet base, @Nullable PermissionOverwrite everyoneOverwrite, List<PermissionOverwrite> roleOverwrites, @Nullable PermissionOverwrite memberOverwrite) {
        if (base.contains((Object)Permission.ADMINISTRATOR)) {
            return PermissionSet.all();
        }
        ArrayList<PermissionOverwrite> allOverwrites = new ArrayList<PermissionOverwrite>();
        if (everyoneOverwrite != null) {
            allOverwrites.add(everyoneOverwrite);
        }
        allOverwrites.addAll(roleOverwrites);
        if (memberOverwrite != null) {
            allOverwrites.add(memberOverwrite);
        }
        return allOverwrites.stream().reduce(base, PermissionUtil::applyOverwrite, PermissionSet::or);
    }

    private static PermissionSet applyOverwrite(PermissionSet base, PermissionOverwrite overwrite) {
        return base.and(overwrite.getDenied().not()).or(overwrite.getAllowed());
    }
}

